/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.cxf;

import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptorProvider;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.SecurityConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.neethi.All;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.security.WSSConfig;
import sun.security.mule.krb5.cxf.NegotiationUtils;
import sun.security.mule.krb5.cxf.SpnegoContextTokenInInterceptor;
import sun.security.mule.krb5.cxf.SpnegoContextTokenOutInterceptor;

public class SpnegoTokenInterceptorProvider
extends AbstractPolicyInterceptorProvider {
    static final Log LOG = LogFactory.getLog(SpnegoTokenInterceptorProvider.class);
    private static final long serialVersionUID = -3412111025613191505L;

    public SpnegoTokenInterceptorProvider() {
        super(Arrays.asList(SP11Constants.SPNEGO_CONTEXT_TOKEN, SP12Constants.SPNEGO_CONTEXT_TOKEN));
        this.getOutInterceptors().add(new SpnegoContextTokenOutInterceptor());
        this.getOutFaultInterceptors().add(new SpnegoContextTokenOutInterceptor());
        this.getInInterceptors().add(new SpnegoContextTokenInInterceptor());
        this.getInFaultInterceptors().add(new SpnegoContextTokenInInterceptor());
        LOG.debug((Object)"Added interceptors to the phases");
    }

    public static String setupClient(STSClient client, SoapMessage message, AssertionInfoMap aim) {
        client.setTrust(NegotiationUtils.getTrust10(aim));
        client.setTrust(NegotiationUtils.getTrust13(aim));
        Policy p = new Policy();
        ExactlyOne ea = new ExactlyOne();
        p.addPolicyComponent((PolicyComponent)ea);
        All all = new All();
        all.addPolicyComponent((PolicyComponent)NegotiationUtils.getAddressingPolicy(aim, false));
        ea.addPolicyComponent((PolicyComponent)all);
        client.setPolicy((Object)p);
        client.setSoap11(message.getVersion() == Soap11.getInstance());
        client.setSpnego(true);
        WSSConfig config = WSSConfig.getNewInstance();
        String context = config.getIdAllocator().createSecureId("_", null);
        client.setContext(context);
        String s = message.getContextualProperty(Message.ENDPOINT_ADDRESS).toString();
        client.setLocation(s);
        AlgorithmSuite suite = NegotiationUtils.getAlgorithmSuite(aim);
        if (suite != null) {
            client.setAlgorithmSuite(suite);
            int x = suite.getMaximumSymmetricKeyLength();
            if (x < 256) {
                client.setKeySize(x);
            }
        }
        Map ctx = client.getRequestContext();
        SpnegoTokenInterceptorProvider.mapSecurityProps((Message)message, ctx);
        return s;
    }

    private static void mapSecurityProps(Message message, Map<String, Object> ctx) {
        for (String s : SecurityConstants.ALL_PROPERTIES) {
            Object v = message.getContextualProperty(s);
            if (v == null) continue;
            ctx.put(s, v);
        }
    }
}

