/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.EncryptedData;
import sun.security.mule.krb5.RealmException;
import sun.security.mule.krb5.internal.APOptions;
import sun.security.mule.krb5.internal.KrbApErrException;
import sun.security.mule.krb5.internal.Ticket;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class APReq {
    public int pvno;
    public int msgType;
    public APOptions apOptions;
    public Ticket ticket;
    public EncryptedData authenticator;

    public APReq(APOptions new_apOptions, Ticket new_ticket, EncryptedData new_authenticator) {
        this.pvno = 5;
        this.msgType = 14;
        this.apOptions = new_apOptions;
        this.ticket = new_ticket;
        this.authenticator = new_authenticator;
    }

    public APReq(byte[] data) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        this.init(new DerValue(data));
    }

    public APReq(DerValue encoding) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        this.init(encoding);
    }

    private void init(DerValue encoding) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        if ((encoding.getTag() & 0x1F) != 14 || !encoding.isApplication() || !encoding.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if (der.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.pvno = subDer.getData().getBigInteger().intValue();
        if (this.pvno != 5) {
            throw new KrbApErrException(39);
        }
        subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.msgType = subDer.getData().getBigInteger().intValue();
        if (this.msgType != 14) {
            throw new KrbApErrException(40);
        }
        this.apOptions = APOptions.parse(der.getData(), (byte)2, false);
        this.ticket = Ticket.parse(der.getData(), (byte)3, false);
        this.authenticator = EncryptedData.parse(der.getData(), (byte)4, false);
        if (der.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.pvno));
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        temp = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.msgType));
        bytes.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)2), this.apOptions.asn1Encode());
        bytes.write(DerValue.createTag((byte)-128, true, (byte)3), this.ticket.asn1Encode());
        bytes.write(DerValue.createTag((byte)-128, true, (byte)4), this.authenticator.asn1Encode());
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        DerOutputStream apreq = new DerOutputStream();
        apreq.write(DerValue.createTag((byte)64, true, (byte)14), temp);
        return apreq.toByteArray();
    }
}

