/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.RealmException;
import sun.security.mule.krb5.internal.HostAddress;
import sun.security.mule.krb5.internal.HostAddresses;
import sun.security.mule.krb5.internal.KerberosTime;
import sun.security.mule.krb5.internal.KrbCredInfo;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class EncKrbCredPart {
    public KrbCredInfo[] ticketInfo = null;
    public KerberosTime timeStamp;
    private Integer nonce;
    private Integer usec;
    private HostAddress sAddress;
    private HostAddresses rAddress;
    private Config kerberosConfig;

    public EncKrbCredPart(KrbCredInfo[] new_ticketInfo, KerberosTime new_timeStamp, Integer new_usec, Integer new_nonce, HostAddress new_sAddress, HostAddresses new_rAddress, Config kerberosConfig) throws IOException {
        if (new_ticketInfo != null) {
            this.ticketInfo = new KrbCredInfo[new_ticketInfo.length];
            for (int i = 0; i < new_ticketInfo.length; ++i) {
                if (new_ticketInfo[i] == null) {
                    throw new IOException("Cannot create a EncKrbCredPart");
                }
                this.ticketInfo[i] = (KrbCredInfo)new_ticketInfo[i].clone();
            }
        }
        this.timeStamp = new_timeStamp;
        this.usec = new_usec;
        this.nonce = new_nonce;
        this.sAddress = new_sAddress;
        this.rAddress = new_rAddress;
        this.kerberosConfig = kerberosConfig;
    }

    public EncKrbCredPart(byte[] data, Config kerberosConfig) throws Asn1Exception, IOException, RealmException {
        this.kerberosConfig = kerberosConfig;
        this.init(new DerValue(data));
    }

    public EncKrbCredPart(DerValue encoding, Config kerberoConfig) throws Asn1Exception, IOException, RealmException {
        this.kerberosConfig = kerberoConfig;
        this.init(encoding);
    }

    private void init(DerValue encoding) throws Asn1Exception, IOException, RealmException {
        this.nonce = null;
        this.timeStamp = null;
        this.usec = null;
        this.sAddress = null;
        this.rAddress = null;
        if ((encoding.getTag() & 0x1F) != 29 || !encoding.isApplication() || !encoding.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if (der.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) == 0) {
            DerValue[] derValues = subDer.getData().getSequence(1);
            this.ticketInfo = new KrbCredInfo[derValues.length];
            for (int i = 0; i < derValues.length; ++i) {
                this.ticketInfo[i] = new KrbCredInfo(derValues[i]);
            }
        } else {
            throw new Asn1Exception(906);
        }
        if (der.getData().available() > 0 && ((byte)der.getData().peekByte() & 0x1F) == 1) {
            subDer = der.getData().getDerValue();
            this.nonce = new Integer(subDer.getData().getBigInteger().intValue());
        }
        if (der.getData().available() > 0) {
            this.timeStamp = KerberosTime.parse(der.getData(), (byte)2, true, this.kerberosConfig);
        }
        if (der.getData().available() > 0 && ((byte)der.getData().peekByte() & 0x1F) == 3) {
            subDer = der.getData().getDerValue();
            this.usec = new Integer(subDer.getData().getBigInteger().intValue());
        }
        if (der.getData().available() > 0) {
            this.sAddress = HostAddress.parse(der.getData(), (byte)4, true);
        }
        if (der.getData().available() > 0) {
            this.rAddress = HostAddresses.parse(der.getData(), (byte)5, true);
        }
        if (der.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        DerValue[] tickets = new DerValue[this.ticketInfo.length];
        for (int i = 0; i < this.ticketInfo.length; ++i) {
            tickets[i] = new DerValue(this.ticketInfo[i].asn1Encode());
        }
        temp.putSequence(tickets);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        if (this.nonce != null) {
            temp = new DerOutputStream();
            temp.putInteger(BigInteger.valueOf(this.nonce.intValue()));
            bytes.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        }
        if (this.timeStamp != null) {
            bytes.write(DerValue.createTag((byte)-128, true, (byte)2), this.timeStamp.asn1Encode());
        }
        if (this.usec != null) {
            temp = new DerOutputStream();
            temp.putInteger(BigInteger.valueOf(this.usec.intValue()));
            bytes.write(DerValue.createTag((byte)-128, true, (byte)3), temp);
        }
        if (this.sAddress != null) {
            bytes.write(DerValue.createTag((byte)-128, true, (byte)4), this.sAddress.asn1Encode());
        }
        if (this.rAddress != null) {
            bytes.write(DerValue.createTag((byte)-128, true, (byte)5), this.rAddress.asn1Encode());
        }
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        bytes = new DerOutputStream();
        bytes.write(DerValue.createTag((byte)64, true, (byte)29), temp);
        return bytes.toByteArray();
    }
}

