/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Vector;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.KrbException;
import sun.security.mule.krb5.PrincipalName;
import sun.security.mule.krb5.internal.HostAddress;
import sun.security.mule.krb5.internal.Krb5;
import sun.security.mule.krb5.internal.ccache.CCacheOutputStream;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class HostAddresses
implements Cloneable {
    private static boolean DEBUG = Krb5.DEBUG;
    private HostAddress[] addresses = null;
    private volatile int hashCode = 0;

    public HostAddresses(HostAddress[] new_addresses) throws IOException {
        if (new_addresses != null) {
            this.addresses = new HostAddress[new_addresses.length];
            for (int i = 0; i < new_addresses.length; ++i) {
                if (new_addresses[i] == null) {
                    throw new IOException("Cannot create a HostAddress");
                }
                this.addresses[i] = (HostAddress)new_addresses[i].clone();
            }
        }
    }

    public HostAddresses() throws UnknownHostException {
        this.addresses = new HostAddress[1];
        this.addresses[0] = new HostAddress();
    }

    private HostAddresses(int dummy) {
    }

    public HostAddresses(PrincipalName serverPrincipal) throws UnknownHostException, KrbException {
        String[] components = serverPrincipal.getNameStrings();
        if (serverPrincipal.getNameType() != 3 || components.length < 2) {
            throw new KrbException(60, "Bad name");
        }
        String host = components[1];
        InetAddress[] addr = InetAddress.getAllByName(host);
        HostAddress[] hAddrs = new HostAddress[addr.length];
        for (int i = 0; i < addr.length; ++i) {
            hAddrs[i] = new HostAddress(addr[i]);
        }
        this.addresses = hAddrs;
    }

    public Object clone() {
        HostAddresses new_hostAddresses = new HostAddresses(0);
        if (this.addresses != null) {
            new_hostAddresses.addresses = new HostAddress[this.addresses.length];
            for (int i = 0; i < this.addresses.length; ++i) {
                new_hostAddresses.addresses[i] = (HostAddress)this.addresses[i].clone();
            }
        }
        return new_hostAddresses;
    }

    public boolean inList(HostAddress addr) {
        if (this.addresses != null) {
            for (int i = 0; i < this.addresses.length; ++i) {
                if (!this.addresses[i].equals(addr)) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            if (this.addresses != null) {
                for (int i = 0; i < this.addresses.length; ++i) {
                    result = 37 * result + this.addresses[i].hashCode();
                }
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HostAddresses)) {
            return false;
        }
        HostAddresses addrs = (HostAddresses)obj;
        if (this.addresses == null && addrs.addresses != null || this.addresses != null && addrs.addresses == null) {
            return false;
        }
        if (this.addresses != null && addrs.addresses != null) {
            if (this.addresses.length != addrs.addresses.length) {
                return false;
            }
            for (int i = 0; i < this.addresses.length; ++i) {
                if (this.addresses[i].equals(addrs.addresses[i])) continue;
                return false;
            }
        }
        return true;
    }

    public HostAddresses(DerValue encoding) throws Asn1Exception, IOException {
        Vector<HostAddress> tempAddresses = new Vector<HostAddress>();
        DerValue der = null;
        while (encoding.getData().available() > 0) {
            der = encoding.getData().getDerValue();
            tempAddresses.addElement(new HostAddress(der));
        }
        if (tempAddresses.size() > 0) {
            this.addresses = new HostAddress[tempAddresses.size()];
            tempAddresses.copyInto(this.addresses);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        if (this.addresses != null && this.addresses.length > 0) {
            for (int i = 0; i < this.addresses.length; ++i) {
                bytes.write(this.addresses[i].asn1Encode());
            }
        }
        temp.write((byte)48, bytes);
        return temp.toByteArray();
    }

    public static HostAddresses parse(DerInputStream data, byte explicitTag, boolean optional) throws Asn1Exception, IOException {
        if (optional && ((byte)data.peekByte() & 0x1F) != explicitTag) {
            return null;
        }
        DerValue der = data.getDerValue();
        if (explicitTag != (der.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        return new HostAddresses(subDer);
    }

    public void writeAddrs(CCacheOutputStream cos) throws IOException {
        cos.write32(this.addresses.length);
        for (int i = 0; i < this.addresses.length; ++i) {
            cos.write16(this.addresses[i].addrType);
            cos.write32(this.addresses[i].address.length);
            cos.write(this.addresses[i].address, 0, this.addresses[i].address.length);
        }
    }

    public InetAddress[] getInetAddresses() {
        if (this.addresses == null || this.addresses.length == 0) {
            return null;
        }
        ArrayList<InetAddress> ipAddrs = new ArrayList<InetAddress>(this.addresses.length);
        for (int i = 0; i < this.addresses.length; ++i) {
            try {
                if (this.addresses[i].addrType != 2 && this.addresses[i].addrType != 24) continue;
                ipAddrs.add(this.addresses[i].getInetAddress());
                continue;
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        InetAddress[] retVal = new InetAddress[ipAddrs.size()];
        return ipAddrs.toArray(retVal);
    }

    public static HostAddresses getLocalAddresses() throws IOException {
        String hostname = null;
        InetAddress[] inetAddresses = null;
        try {
            int i;
            InetAddress localHost = InetAddress.getLocalHost();
            hostname = localHost.getHostName();
            inetAddresses = InetAddress.getAllByName(hostname);
            HostAddress[] hAddresses = new HostAddress[inetAddresses.length];
            for (i = 0; i < inetAddresses.length; ++i) {
                hAddresses[i] = new HostAddress(inetAddresses[i]);
            }
            if (DEBUG) {
                System.out.println(">>> KrbKdcReq local addresses for " + hostname + " are: ");
                for (i = 0; i < inetAddresses.length; ++i) {
                    System.out.println("\n\t" + inetAddresses[i]);
                    if (inetAddresses[i] instanceof Inet4Address) {
                        System.out.println("IPv4 address");
                    }
                    if (!(inetAddresses[i] instanceof Inet6Address)) continue;
                    System.out.println("IPv6 address");
                }
            }
            return new HostAddresses(hAddresses);
        }
        catch (Exception exc) {
            throw new IOException(exc.toString());
        }
    }

    public HostAddresses(InetAddress[] inetAddresses) {
        if (inetAddresses == null) {
            this.addresses = null;
            return;
        }
        this.addresses = new HostAddress[inetAddresses.length];
        for (int i = 0; i < inetAddresses.length; ++i) {
            this.addresses[i] = new HostAddress(inetAddresses[i]);
        }
    }
}

