/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal;

import java.io.IOException;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.internal.Krb5;
import sun.security.mule.krb5.internal.util.KerberosFlags;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;

public class KDCOptions
extends KerberosFlags {
    public final int KDC_OPT_PROXIABLE = 0x10000000;
    public final int KDC_OPT_RENEWABLE_OK = 16;
    public final int KDC_OPT_FORWARDABLE = 0x40000000;
    public static final int RESERVED = 0;
    public static final int FORWARDABLE = 1;
    public static final int FORWARDED = 2;
    public static final int PROXIABLE = 3;
    public static final int PROXY = 4;
    public static final int ALLOW_POSTDATE = 5;
    public static final int POSTDATED = 6;
    public static final int UNUSED7 = 7;
    public static final int RENEWABLE = 8;
    public static final int UNUSED9 = 9;
    public static final int UNUSED10 = 10;
    public static final int UNUSED11 = 11;
    public static final int RENEWABLE_OK = 27;
    public static final int ENC_TKT_IN_SKEY = 28;
    public static final int RENEW = 30;
    public static final int VALIDATE = 31;
    private boolean DEBUG = Krb5.DEBUG;

    public KDCOptions(Config kerberosConfig) {
        super(32);
        this.setDefault(kerberosConfig);
    }

    public KDCOptions(int size, byte[] data) throws Asn1Exception {
        super(size, data);
        if (size > data.length * 8 || size > 32) {
            throw new Asn1Exception(502);
        }
    }

    public KDCOptions(boolean[] data) throws Asn1Exception {
        super(data);
        if (data.length > 32) {
            throw new Asn1Exception(502);
        }
    }

    public KDCOptions(DerValue encoding) throws Asn1Exception, IOException {
        this(encoding.getUnalignedBitString(true).toBooleanArray());
    }

    public KDCOptions(byte[] options) {
        super(options.length * 8, options);
    }

    public static KDCOptions parse(DerInputStream data, byte explicitTag, boolean optional) throws Asn1Exception, IOException {
        if (optional && ((byte)data.peekByte() & 0x1F) != explicitTag) {
            return null;
        }
        DerValue der = data.getDerValue();
        if (explicitTag != (der.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        return new KDCOptions(subDer);
    }

    @Override
    public void set(int option, boolean value) throws ArrayIndexOutOfBoundsException {
        super.set(option, value);
    }

    @Override
    public boolean get(int option) throws ArrayIndexOutOfBoundsException {
        return super.get(option);
    }

    private void setDefault(Config config) {
        int options = config.getDefaultIntValue("kdc_default_options", "libdefaults");
        if ((options & 0x1B) == 27) {
            this.set(27, true);
        } else if (config.getDefaultBooleanValue("renewable", "libdefaults")) {
            this.set(27, true);
        }
        if ((options & 3) == 3) {
            this.set(3, true);
        } else if (config.getDefaultBooleanValue("proxiable", "libdefaults")) {
            this.set(3, true);
        }
        if ((options & 1) == 1) {
            this.set(1, true);
        } else if (config.getDefaultBooleanValue("forwardable", "libdefaults")) {
            this.set(1, true);
        }
    }
}

