/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.EncryptedData;
import sun.security.mule.krb5.RealmException;
import sun.security.mule.krb5.internal.KrbApErrException;
import sun.security.mule.krb5.internal.Ticket;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class KRBCred {
    public Ticket[] tickets = null;
    public EncryptedData encPart;
    private int pvno;
    private int msgType;

    public KRBCred(Ticket[] new_tickets, EncryptedData new_encPart) throws IOException {
        this.pvno = 5;
        this.msgType = 22;
        if (new_tickets != null) {
            this.tickets = new Ticket[new_tickets.length];
            for (int i = 0; i < new_tickets.length; ++i) {
                if (new_tickets[i] == null) {
                    throw new IOException("Cannot create a KRBCred");
                }
                this.tickets[i] = (Ticket)new_tickets[i].clone();
            }
        }
        this.encPart = new_encPart;
    }

    public KRBCred(byte[] data) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.init(new DerValue(data));
    }

    public KRBCred(DerValue encoding) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.init(encoding);
    }

    private void init(DerValue encoding) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        if ((encoding.getTag() & 0x1F) != 22 || !encoding.isApplication() || !encoding.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if (der.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) == 0) {
            this.pvno = subDer.getData().getBigInteger().intValue();
            if (this.pvno != 5) {
                throw new KrbApErrException(39);
            }
        } else {
            throw new Asn1Exception(906);
        }
        subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) == 1) {
            this.msgType = subDer.getData().getBigInteger().intValue();
            if (this.msgType != 22) {
                throw new KrbApErrException(40);
            }
        } else {
            throw new Asn1Exception(906);
        }
        subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) == 2) {
            DerValue subsubDer = subDer.getData().getDerValue();
            if (subsubDer.getTag() != 48) {
                throw new Asn1Exception(906);
            }
            Vector<Ticket> v = new Vector<Ticket>();
            while (subsubDer.getData().available() > 0) {
                v.addElement(new Ticket(subsubDer.getData().getDerValue()));
            }
            if (v.size() > 0) {
                this.tickets = new Ticket[v.size()];
                v.copyInto(this.tickets);
            }
        } else {
            throw new Asn1Exception(906);
        }
        this.encPart = EncryptedData.parse(der.getData(), (byte)3, false);
        if (der.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream temp = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.pvno));
        DerOutputStream out = new DerOutputStream();
        out.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        temp = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.msgType));
        out.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        temp = new DerOutputStream();
        for (int i = 0; i < this.tickets.length; ++i) {
            temp.write(this.tickets[i].asn1Encode());
        }
        DerOutputStream bytes = new DerOutputStream();
        bytes.write((byte)48, temp);
        out.write(DerValue.createTag((byte)-128, true, (byte)2), bytes);
        out.write(DerValue.createTag((byte)-128, true, (byte)3), this.encPart.asn1Encode());
        bytes = new DerOutputStream();
        bytes.write((byte)48, out);
        out = new DerOutputStream();
        out.write(DerValue.createTag((byte)64, true, (byte)22), bytes);
        return out.toByteArray();
    }
}

