/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.Checksum;
import sun.security.mule.krb5.RealmException;
import sun.security.mule.krb5.internal.KRBSafeBody;
import sun.security.mule.krb5.internal.KrbApErrException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class KRBSafe {
    public int pvno;
    public int msgType;
    public KRBSafeBody safeBody;
    public Checksum cksum;

    public KRBSafe(KRBSafeBody new_safeBody, Checksum new_cksum) {
        this.pvno = 5;
        this.msgType = 20;
        this.safeBody = new_safeBody;
        this.cksum = new_cksum;
    }

    public KRBSafe(byte[] data) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.init(new DerValue(data));
    }

    public KRBSafe(DerValue encoding) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.init(encoding);
    }

    private void init(DerValue encoding) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        if ((encoding.getTag() & 0x1F) != 20 || !encoding.isApplication() || !encoding.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if (der.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) == 0) {
            this.pvno = subDer.getData().getBigInteger().intValue();
            if (this.pvno != 5) {
                throw new KrbApErrException(39);
            }
        } else {
            throw new Asn1Exception(906);
        }
        subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) == 1) {
            this.msgType = subDer.getData().getBigInteger().intValue();
            if (this.msgType != 20) {
                throw new KrbApErrException(40);
            }
        } else {
            throw new Asn1Exception(906);
        }
        this.safeBody = KRBSafeBody.parse(der.getData(), (byte)2, false);
        this.cksum = Checksum.parse(der.getData(), (byte)3, false);
        if (der.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream temp = new DerOutputStream();
        DerOutputStream bytes = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.pvno));
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        temp = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.msgType));
        bytes.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)2), this.safeBody.asn1Encode());
        bytes.write(DerValue.createTag((byte)-128, true, (byte)3), this.cksum.asn1Encode());
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        bytes = new DerOutputStream();
        bytes.write(DerValue.createTag((byte)64, true, (byte)20), temp);
        return bytes.toByteArray();
    }
}

