/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.internal.Krb5;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class KerberosTime
implements Cloneable {
    private long kerberosTime;
    private Config kerberosConfig;
    private static long syncTime;
    private static boolean DEBUG;
    public static final boolean NOW = true;
    public static final boolean UNADJUSTED_NOW = false;

    public KerberosTime(Config kerberosConfig) {
        this.kerberosTime = 0L;
        this.kerberosConfig = kerberosConfig;
    }

    public KerberosTime(long time, Config kerberosConfig) {
        this.kerberosTime = time;
        this.kerberosConfig = kerberosConfig;
    }

    public Object clone() {
        return new KerberosTime(this.kerberosTime, this.kerberosConfig);
    }

    public KerberosTime(String time, Config kerberosConfig) throws Asn1Exception {
        this.kerberosTime = KerberosTime.toKerberosTime(time);
        this.kerberosConfig = kerberosConfig;
    }

    public KerberosTime(DerValue encoding, Config kerberosConfig) throws Asn1Exception, IOException {
        GregorianCalendar calendar = new GregorianCalendar();
        Date temp = encoding.getGeneralizedTime();
        this.kerberosTime = temp.getTime();
        this.kerberosConfig = kerberosConfig;
    }

    private static long toKerberosTime(String time) throws Asn1Exception {
        if (time.length() != 15) {
            throw new Asn1Exception(900);
        }
        if (time.charAt(14) != 'Z') {
            throw new Asn1Exception(900);
        }
        int year = Integer.parseInt(time.substring(0, 4));
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        calendar.set(year, Integer.parseInt(time.substring(4, 6)) - 1, Integer.parseInt(time.substring(6, 8)), Integer.parseInt(time.substring(8, 10)), Integer.parseInt(time.substring(10, 12)), Integer.parseInt(time.substring(12, 14)));
        return calendar.getTime().getTime();
    }

    public static String zeroPad(String s, int length) {
        StringBuffer temp = new StringBuffer(s);
        while (temp.length() < length) {
            temp.insert(0, '0');
        }
        return temp.toString();
    }

    public KerberosTime(Date time, Config kerberosConfig) {
        this.kerberosTime = time.getTime();
        this.kerberosConfig = kerberosConfig;
    }

    public KerberosTime(boolean initToNow, Config kerConfig) {
        this.kerberosConfig = kerConfig;
        if (initToNow) {
            Date temp = new Date();
            this.setTime(temp);
        } else {
            this.kerberosTime = 0L;
        }
    }

    public String toGeneralizedTimeString() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        calendar.setTimeInMillis(this.kerberosTime);
        return KerberosTime.zeroPad(Integer.toString(calendar.get(1)), 4) + KerberosTime.zeroPad(Integer.toString(calendar.get(2) + 1), 2) + KerberosTime.zeroPad(Integer.toString(calendar.get(5)), 2) + KerberosTime.zeroPad(Integer.toString(calendar.get(11)), 2) + KerberosTime.zeroPad(Integer.toString(calendar.get(12)), 2) + KerberosTime.zeroPad(Integer.toString(calendar.get(13)), 2) + 'Z';
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream out = new DerOutputStream();
        out.putGeneralizedTime(this.toDate());
        return out.toByteArray();
    }

    public long getTime() {
        return this.kerberosTime;
    }

    public void setTime(Date time) {
        this.kerberosTime = time.getTime();
    }

    public void setTime(long time) {
        this.kerberosTime = time;
    }

    public Date toDate() {
        Date temp = new Date(this.kerberosTime);
        temp.setTime(temp.getTime());
        return temp;
    }

    public void setNow() {
        Date temp = new Date();
        this.setTime(temp);
    }

    public int getMicroSeconds() {
        Long temp_long = new Long(this.kerberosTime % 1000L * 1000L);
        return temp_long.intValue();
    }

    public void setMicroSeconds(int usec) {
        Integer temp_int = new Integer(usec);
        long temp_long = temp_int.longValue() / 1000L;
        this.kerberosTime = this.kerberosTime - this.kerberosTime % 1000L + temp_long;
    }

    public void setMicroSeconds(Integer usec) {
        if (usec != null) {
            long temp_long = usec.longValue() / 1000L;
            this.kerberosTime = this.kerberosTime - this.kerberosTime % 1000L + temp_long;
        }
    }

    public boolean inClockSkew(int clockSkew) {
        KerberosTime now = new KerberosTime(true, this.kerberosConfig);
        return Math.abs(this.kerberosTime - now.kerberosTime) <= (long)clockSkew * 1000L;
    }

    public boolean inClockSkew() {
        return this.inClockSkew(KerberosTime.getDefaultSkew(this.kerberosConfig));
    }

    public boolean inClockSkew(int clockSkew, KerberosTime now) {
        return Math.abs(this.kerberosTime - now.kerberosTime) <= (long)clockSkew * 1000L;
    }

    public boolean inClockSkew(KerberosTime time) {
        return this.inClockSkew(KerberosTime.getDefaultSkew(this.kerberosConfig), time);
    }

    public boolean greaterThanWRTClockSkew(KerberosTime time, int clockSkew) {
        return this.kerberosTime - time.kerberosTime > (long)clockSkew * 1000L;
    }

    public boolean greaterThanWRTClockSkew(KerberosTime time) {
        return this.greaterThanWRTClockSkew(time, KerberosTime.getDefaultSkew(this.kerberosConfig));
    }

    public boolean greaterThan(KerberosTime time) {
        return this.kerberosTime > time.kerberosTime;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KerberosTime)) {
            return false;
        }
        return this.kerberosTime == ((KerberosTime)obj).kerberosTime;
    }

    public int hashCode() {
        return 629 + (int)(this.kerberosTime ^ this.kerberosTime >>> 32);
    }

    public boolean isZero() {
        return this.kerberosTime == 0L;
    }

    public int getSeconds() {
        Long temp_long = new Long(this.kerberosTime / 1000L);
        return temp_long.intValue();
    }

    public void setSeconds(int sec) {
        Integer temp_int = new Integer(sec);
        this.kerberosTime = temp_int.longValue() * 1000L;
    }

    public static KerberosTime parse(DerInputStream data, byte explicitTag, boolean optional, Config kerberosConfig) throws Asn1Exception, IOException {
        if (optional && ((byte)data.peekByte() & 0x1F) != explicitTag) {
            return null;
        }
        DerValue der = data.getDerValue();
        if (explicitTag != (der.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        return new KerberosTime(subDer, kerberosConfig);
    }

    public static int getDefaultSkew(Config kerberosConfig) {
        int tdiff = 300;
        tdiff = kerberosConfig.getDefaultIntValue("clockskew", "libdefaults");
        if (tdiff == Integer.MIN_VALUE) {
            tdiff = 300;
        }
        return tdiff;
    }

    public String toString() {
        return this.toGeneralizedTimeString();
    }

    static {
        DEBUG = Krb5.DEBUG;
    }
}

