/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal;

import java.io.IOException;
import java.util.Vector;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.internal.LastReqEntry;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class LastReq {
    private LastReqEntry[] entry = null;
    private Config kerberosConfig;

    public LastReq(LastReqEntry[] entries, Config kerberosConfig) throws IOException {
        this.kerberosConfig = kerberosConfig;
        if (entries != null) {
            this.entry = new LastReqEntry[entries.length];
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i] == null) {
                    throw new IOException("Cannot create a LastReqEntry");
                }
                this.entry[i] = (LastReqEntry)entries[i].clone();
            }
        }
    }

    public LastReq(DerValue encoding, Config kerberosConfig) throws Asn1Exception, IOException {
        this.kerberosConfig = kerberosConfig;
        Vector<LastReqEntry> v = new Vector<LastReqEntry>();
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        while (encoding.getData().available() > 0) {
            v.addElement(new LastReqEntry(encoding.getData().getDerValue(), kerberosConfig));
        }
        if (v.size() > 0) {
            this.entry = new LastReqEntry[v.size()];
            v.copyInto(this.entry);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        if (this.entry != null && this.entry.length > 0) {
            DerOutputStream temp = new DerOutputStream();
            for (int i = 0; i < this.entry.length; ++i) {
                temp.write(this.entry[i].asn1Encode());
            }
            bytes.write((byte)48, temp);
            return bytes.toByteArray();
        }
        return null;
    }

    public static LastReq parse(DerInputStream data, byte explicitTag, boolean optional, Config kerberosConfig) throws Asn1Exception, IOException {
        if (optional && ((byte)data.peekByte() & 0x1F) != explicitTag) {
            return null;
        }
        DerValue der = data.getDerValue();
        if (explicitTag != (der.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        return new LastReq(subDer, kerberosConfig);
    }
}

