/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal;

import java.io.IOException;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.internal.KerberosTime;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class LastReqEntry {
    private int lrType;
    private KerberosTime lrValue;
    private Config kerberosConfig;

    private LastReqEntry(Config kerberosConfig) {
        this.kerberosConfig = kerberosConfig;
    }

    public LastReqEntry(int Type2, KerberosTime time, Config kerberosConfig) {
        this.kerberosConfig = kerberosConfig;
        this.lrType = Type2;
        this.lrValue = time;
    }

    public LastReqEntry(DerValue encoding, Config kerberosConfig) throws Asn1Exception, IOException {
        this.kerberosConfig = kerberosConfig;
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.lrType = der.getData().getBigInteger().intValue();
        this.lrValue = KerberosTime.parse(encoding.getData(), (byte)1, false, kerberosConfig);
        if (encoding.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        temp.putInteger(this.lrType);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)1), this.lrValue.asn1Encode());
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        return temp.toByteArray();
    }

    public Object clone() {
        LastReqEntry newEntry = new LastReqEntry(this.kerberosConfig);
        newEntry.lrType = this.lrType;
        newEntry.lrValue = (KerberosTime)this.lrValue.clone();
        return newEntry;
    }
}

