/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal.crypto;

import java.security.InvalidKeyException;
import javax.crypto.spec.DESKeySpec;
import sun.security.mule.krb5.KrbCryptoException;
import sun.security.mule.krb5.internal.crypto.CksumType;
import sun.security.mule.krb5.internal.crypto.Des;

public class DesMacKCksumType
extends CksumType {
    @Override
    public int confounderSize() {
        return 0;
    }

    @Override
    public int cksumType() {
        return 5;
    }

    @Override
    public boolean isSafe() {
        return true;
    }

    @Override
    public int cksumSize() {
        return 16;
    }

    @Override
    public int keyType() {
        return 1;
    }

    @Override
    public int keySize() {
        return 8;
    }

    @Override
    public byte[] calculateChecksum(byte[] data, int size) {
        return null;
    }

    @Override
    public byte[] calculateKeyedChecksum(byte[] data, int size, byte[] key, int usage) throws KrbCryptoException {
        try {
            if (DESKeySpec.isWeak(key, 0)) {
                key[7] = (byte)(key[7] ^ 0xF0);
            }
        }
        catch (InvalidKeyException ex) {
            // empty catch block
        }
        byte[] ivec = new byte[key.length];
        System.arraycopy(key, 0, ivec, 0, key.length);
        byte[] cksum = Des.des_cksum(ivec, data, key);
        return cksum;
    }

    @Override
    public boolean verifyKeyedChecksum(byte[] data, int size, byte[] key, byte[] checksum, int usage) throws KrbCryptoException {
        byte[] new_cksum = this.calculateKeyedChecksum(data, data.length, key, usage);
        return DesMacKCksumType.isChecksumEqual(checksum, new_cksum);
    }
}

