/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal.crypto;

import java.security.GeneralSecurityException;
import sun.security.mule.krb5.KrbCryptoException;
import sun.security.mule.krb5.internal.crypto.Aes256;
import sun.security.mule.krb5.internal.crypto.CksumType;

public class HmacSha1Aes256CksumType
extends CksumType {
    @Override
    public int confounderSize() {
        return 16;
    }

    @Override
    public int cksumType() {
        return 16;
    }

    @Override
    public boolean isSafe() {
        return true;
    }

    @Override
    public int cksumSize() {
        return 12;
    }

    @Override
    public int keyType() {
        return 3;
    }

    @Override
    public int keySize() {
        return 32;
    }

    @Override
    public byte[] calculateChecksum(byte[] data, int size) {
        return null;
    }

    @Override
    public byte[] calculateKeyedChecksum(byte[] data, int size, byte[] key, int usage) throws KrbCryptoException {
        try {
            return Aes256.calculateChecksum(key, usage, data, 0, size);
        }
        catch (GeneralSecurityException e) {
            KrbCryptoException ke = new KrbCryptoException(e.getMessage());
            ke.initCause(e);
            throw ke;
        }
    }

    @Override
    public boolean verifyKeyedChecksum(byte[] data, int size, byte[] key, byte[] checksum, int usage) throws KrbCryptoException {
        try {
            byte[] newCksum = Aes256.calculateChecksum(key, usage, data, 0, size);
            return HmacSha1Aes256CksumType.isChecksumEqual(checksum, newCksum);
        }
        catch (GeneralSecurityException e) {
            KrbCryptoException ke = new KrbCryptoException(e.getMessage());
            ke.initCause(e);
            throw ke;
        }
    }
}

