/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal.crypto;

import java.security.GeneralSecurityException;
import sun.security.mule.krb5.KrbCryptoException;
import sun.security.mule.krb5.internal.crypto.CksumType;
import sun.security.mule.krb5.internal.crypto.Des3;

public class HmacSha1Des3KdCksumType
extends CksumType {
    @Override
    public int confounderSize() {
        return 8;
    }

    @Override
    public int cksumType() {
        return 12;
    }

    @Override
    public boolean isSafe() {
        return true;
    }

    @Override
    public int cksumSize() {
        return 20;
    }

    @Override
    public int keyType() {
        return 2;
    }

    @Override
    public int keySize() {
        return 24;
    }

    @Override
    public byte[] calculateChecksum(byte[] data, int size) {
        return null;
    }

    @Override
    public byte[] calculateKeyedChecksum(byte[] data, int size, byte[] key, int usage) throws KrbCryptoException {
        try {
            return Des3.calculateChecksum(key, usage, data, 0, size);
        }
        catch (GeneralSecurityException e) {
            KrbCryptoException ke = new KrbCryptoException(e.getMessage());
            ke.initCause(e);
            throw ke;
        }
    }

    @Override
    public boolean verifyKeyedChecksum(byte[] data, int size, byte[] key, byte[] checksum, int usage) throws KrbCryptoException {
        try {
            byte[] newCksum = Des3.calculateChecksum(key, usage, data, 0, size);
            return HmacSha1Des3KdCksumType.isChecksumEqual(checksum, newCksum);
        }
        catch (GeneralSecurityException e) {
            KrbCryptoException ke = new KrbCryptoException(e.getMessage());
            ke.initCause(e);
            throw ke;
        }
    }
}

