/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal.ktab;

import java.io.UnsupportedEncodingException;
import sun.security.mule.krb5.EncryptionKey;
import sun.security.mule.krb5.PrincipalName;
import sun.security.mule.krb5.Realm;
import sun.security.mule.krb5.internal.KerberosTime;
import sun.security.mule.krb5.internal.Krb5;
import sun.security.mule.krb5.internal.ktab.KeyTabConstants;

public class KeyTabEntry
implements KeyTabConstants {
    PrincipalName service;
    Realm realm;
    KerberosTime timestamp;
    int keyVersion;
    int keyType;
    byte[] keyblock = null;
    boolean DEBUG = Krb5.DEBUG;

    public KeyTabEntry(PrincipalName new_service, Realm new_realm, KerberosTime new_time, int new_keyVersion, int new_keyType, byte[] new_keyblock) {
        this.service = new_service;
        this.realm = new_realm;
        this.timestamp = new_time;
        this.keyVersion = new_keyVersion;
        this.keyType = new_keyType;
        if (new_keyblock != null) {
            this.keyblock = (byte[])new_keyblock.clone();
        }
    }

    public PrincipalName getService() {
        return this.service;
    }

    public EncryptionKey getKey() {
        EncryptionKey key = new EncryptionKey(this.keyblock, this.keyType, new Integer(this.keyVersion));
        return key;
    }

    public String getKeyString() {
        StringBuffer sb = new StringBuffer("0x");
        for (int i = 0; i < this.keyblock.length; ++i) {
            sb.append(Integer.toHexString(this.keyblock[i] & 0xFF));
        }
        return sb.toString();
    }

    public int entryLength() {
        int totalPrincipalLength = 0;
        String[] names = this.service.getNameStrings();
        for (int i = 0; i < names.length; ++i) {
            try {
                totalPrincipalLength += 2 + names[i].getBytes("8859_1").length;
                continue;
            }
            catch (UnsupportedEncodingException exc) {
                // empty catch block
            }
        }
        int realmLen = 0;
        try {
            realmLen = this.realm.toString().getBytes("8859_1").length;
        }
        catch (UnsupportedEncodingException exc) {
            // empty catch block
        }
        int size = 4 + realmLen + totalPrincipalLength + 4 + 4 + 1 + 2 + 2 + this.keyblock.length;
        if (this.DEBUG) {
            System.out.println(">>> KeyTabEntry: key tab entry size is " + size);
        }
        return size;
    }

    public KerberosTime getTimeStamp() {
        return this.timestamp;
    }
}

