/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal.ktab;

import java.io.IOException;
import java.io.InputStream;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.PrincipalName;
import sun.security.mule.krb5.Realm;
import sun.security.mule.krb5.RealmException;
import sun.security.mule.krb5.internal.KerberosTime;
import sun.security.mule.krb5.internal.Krb5;
import sun.security.mule.krb5.internal.ktab.KeyTabConstants;
import sun.security.mule.krb5.internal.ktab.KeyTabEntry;
import sun.security.mule.krb5.internal.util.KrbDataInputStream;

public class KeyTabInputStream
extends KrbDataInputStream
implements KeyTabConstants {
    boolean DEBUG = Krb5.DEBUG;
    static int index;

    public KeyTabInputStream(InputStream is) {
        super(is);
    }

    int readEntryLength() throws IOException {
        return this.read(4);
    }

    KeyTabEntry readEntry(int entryLen, int ktVersion, Config kerberosConfig) throws IOException, RealmException {
        index = entryLen;
        if (index == 0) {
            return null;
        }
        if (index < 0) {
            this.skip(Math.abs(index));
            return null;
        }
        int principalNum = this.read(2);
        index -= 2;
        if (ktVersion == 1281) {
            --principalNum;
        }
        Realm realm = new Realm(this.readName());
        String[] nameParts = new String[principalNum];
        for (int i = 0; i < principalNum; ++i) {
            nameParts[i] = this.readName();
        }
        int nameType = this.read(4);
        index -= 4;
        PrincipalName service = new PrincipalName(nameParts, nameType);
        service.setRealm(realm);
        KerberosTime timeStamp = this.readTimeStamp(kerberosConfig);
        int keyVersion = this.read() & 0xFF;
        --index;
        int keyType = this.read(2);
        index -= 2;
        int keyLength = this.read(2);
        index -= 2;
        byte[] keyblock = this.readKey(keyLength);
        if ((index -= keyLength) >= 4) {
            int extKvno = this.read(4);
            if (extKvno != 0) {
                keyVersion = extKvno;
            }
            index -= 4;
        }
        if (index < 0) {
            throw new RealmException("Keytab is corrupted");
        }
        this.skip(index);
        return new KeyTabEntry(service, realm, timeStamp, keyVersion, keyType, keyblock);
    }

    byte[] readKey(int length) throws IOException {
        byte[] bytes = new byte[length];
        this.read(bytes, 0, length);
        return bytes;
    }

    KerberosTime readTimeStamp(Config kerberosConfig) throws IOException {
        index -= 4;
        return new KerberosTime((long)this.read(4) * 1000L, kerberosConfig);
    }

    String readName() throws IOException {
        int length = this.read(2);
        index -= 2;
        byte[] bytes = new byte[length];
        this.read(bytes, 0, length);
        index -= length;
        String name = new String(bytes);
        if (this.DEBUG) {
            System.out.println(">>> KeyTabInputStream, readName(): " + name);
        }
        return name;
    }
}

