/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.mule;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.mule.tools.mule.arm.AuthorizationResponse;
import org.mule.tools.mule.arm.Environment;
import org.mule.tools.mule.arm.Environments;
import org.mule.tools.mule.arm.UserInfo;

public class AbstractMuleApi {
    private static final String ME = "/accounts/api/me";
    private static final String URI = "https://anypoint.mulesoft.com";
    private static final String LOGIN = "/accounts/login";
    private static final String ENVIRONMENTS = "/accounts/api/organizations/%s/environments";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String ENV_ID_HEADER = "X-ANYPNT-ENV-ID";
    private static final String ORG_ID_HEADER = "X-ANYPNT-ORG-ID";
    private String username;
    private String password;
    private String environment;
    private String bearerToken;
    private String envId;
    private String orgId;

    public AbstractMuleApi(String username, String password, String environment) {
        this.username = username;
        this.password = password;
        this.environment = environment;
    }

    public void init() {
        this.bearerToken = this.getBearerToken(this.username, this.password);
        this.orgId = this.getOrgId();
        this.envId = this.findEnvironmentByName((String)this.environment).id;
    }

    protected MultivaluedMap<String, Object> authorizationHeader() {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)AUTHORIZATION_HEADER, (Object)("bearer " + this.bearerToken));
        headers.add((Object)ENV_ID_HEADER, (Object)this.envId);
        headers.add((Object)ORG_ID_HEADER, (Object)this.orgId);
        return headers;
    }

    public String getBearerToken(String username, String password) {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(URI).path(LOGIN);
        Entity json = Entity.json((Object)("{\"username\": \"" + username + "\", \"password\": \"" + password + "\"}"));
        AuthorizationResponse response = (AuthorizationResponse)target.request(new String[]{"text/plain"}).post(json, AuthorizationResponse.class);
        return response.access_token;
    }

    public String getOrgId() {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(URI).path(ME);
        UserInfo response = (UserInfo)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header(AUTHORIZATION_HEADER, (Object)("bearer " + this.bearerToken)).get(UserInfo.class);
        return response.user.organization.id;
    }

    public Environment findEnvironmentByName(String name) {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(URI).path(String.format(ENVIRONMENTS, this.orgId));
        Environments response = (Environments)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header(AUTHORIZATION_HEADER, (Object)("bearer " + this.bearerToken)).get(Environments.class);
        for (int i = 0; i < response.data.length; ++i) {
            if (!name.equals(response.data[i].name)) continue;
            return response.data[i];
        }
        throw new RuntimeException("Couldn't find environment named [" + name + "]");
    }
}

