/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.mule;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.mule.test.infrastructure.process.MuleProcessController;
import org.mule.tools.mule.AbstractMuleMojo;
import org.mule.tools.mule.ArtifactDescription;
import org.mule.tools.mule.ClusterDeployer;
import org.mule.tools.mule.Deployer;
import org.mule.tools.mule.Deployment;
import org.mule.tools.mule.DeploymentException;
import org.mule.tools.mule.TargetType;
import org.mule.tools.mule.agent.AgentDeployer;
import org.mule.tools.mule.arm.ArmDeployer;
import org.mule.tools.mule.cloudhub.CloudhubDeployer;

@Mojo(name="deploy", requiresProject=true)
public class DeployMojo
extends AbstractMuleMojo {
    private static final long DEFAULT_POLLING_DELAY = 1000L;
    private static final Integer MAX_CLUSTER_SIZE = 8;
    @Component
    protected ArchiverManager archiverManager;
    @Parameter(readonly=true, property="mule.version")
    protected String muleVersion;
    @Parameter(readonly=true, property="mule.home")
    protected File muleHome;
    @Parameter(readonly=true, required=false, defaultValue="false", property="mule.community")
    protected boolean community;
    @Parameter(readonly=true)
    private ArtifactDescription muleDistribution;
    @Parameter(property="mule.application")
    private File application;
    @Parameter(property="mule.deployment.timeout", defaultValue="60000", required=true)
    protected Long deploymentTimeout;
    @Parameter(property="mule.arguments", required=false)
    protected String[] arguments;
    @Parameter
    protected List<File> libs = new ArrayList<File>();
    @Parameter(defaultValue="2", readonly=true, required=true)
    protected Integer size;
    @Parameter(required=true, readonly=true)
    protected Deployment deployment;
    @Parameter(required=false, readonly=true, property="anypoint.environment")
    protected String environment;
    @Parameter(required=false, readonly=true, property="anypoint.username")
    protected String username;
    @Parameter(required=false, readonly=true, property="anypoint.password")
    protected String password;
    @Parameter(readonly=true, property="anypoint.target")
    protected String target;
    @Parameter(readonly=true, property="anypoint.target.type")
    protected TargetType targetType;
    @Parameter(readonly=true, property="anypoint.uri", defaultValue="https://anypoint.mulesoft.com")
    protected String uri;
    @Parameter(readonly=true, defaultValue="false")
    protected boolean redeploy;
    @Parameter(readonly=true, property="cloudhub.region", defaultValue="us-east-1")
    protected String region = "us-east-1";
    @Parameter(readonly=true, property="cloudhub.workers", defaultValue="1")
    protected int workers = 1;
    @Parameter(readonly=true, property="cloudhub.workerType", defaultValue="Medium")
    protected String workerType = "Medium";
    @Parameter(readonly=true, property="trustStorePath")
    protected String trustStorePath;
    @Parameter(readonly=true, property="trustStorePassword")
    protected String trustStorePassword;
    @Parameter(readonly=true, property="trustStoreType", defaultValue="jks")
    protected String trustStoreType;
    private String applicationName;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        Deployment.Type type = this.deployment.getType();
        switch (type) {
            case standalone: {
                this.standalone();
                break;
            }
            case cluster: {
                this.cluster();
                break;
            }
            case arm: {
                this.arm();
                break;
            }
            case cloudhub: {
                this.cloudhub();
                break;
            }
            case agent: {
                this.agent();
                break;
            }
            default: {
                throw new MojoFailureException("Unsupported deployment type: " + (Object)((Object)type));
            }
        }
    }

    private void cloudhub() throws MojoFailureException, MojoExecutionException {
        this.initializeApplication();
        CloudhubDeployer deployer = new CloudhubDeployer(this.username, this.password, this.environment, this.application, this.redeploy, this.region, this.muleVersion, this.workers, this.workerType, this.getLog());
        if (null != this.script) {
            this.executeGroovyScript();
        }
        try {
            deployer.execute();
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to deploy [" + this.application + "] " + e.getMessage());
        }
    }

    private void arm() throws MojoFailureException, MojoExecutionException {
        this.initializeApplication();
        ArmDeployer deployer = new ArmDeployer(this.uri, this.username, this.password, this.environment, this.targetType, this.target, this.application, this.applicationName);
        if (null != this.script) {
            this.executeGroovyScript();
        }
        try {
            deployer.execute();
        }
        catch (DeploymentException e) {
            throw new MojoFailureException("Failed to deploy [" + this.application + "]");
        }
    }

    private void agent() throws MojoFailureException, MojoExecutionException {
        this.initializeApplication();
        AgentDeployer deployer = new AgentDeployer(this.getLog(), this.applicationName, this.application, this.uri, this.trustStorePath, this.trustStorePassword, this.trustStoreType);
        if (null != this.script) {
            this.executeGroovyScript();
        }
        try {
            deployer.execute();
        }
        catch (DeploymentException e) {
            throw new MojoFailureException("Failed to deploy [" + this.application + "]");
        }
    }

    private void initializeApplication() throws MojoFailureException {
        if (this.application == null) {
            Artifact artifact = this.resolveMavenProjectArtifact();
            this.applicationName = artifact.getArtifactId();
            this.application = artifact.getFile();
            this.getLog().info((CharSequence)("No application configured. Using project artifact: " + artifact.getFile()));
        } else {
            this.applicationName = this.application.getName();
        }
    }

    private void cluster() throws MojoExecutionException, MojoFailureException {
        this.validateSize();
        File[] muleHomes = new File[this.size.intValue()];
        LinkedList<MuleProcessController> controllers = new LinkedList<MuleProcessController>();
        for (int i = 0; i < this.size; ++i) {
            File buildDirectory = new File(this.mavenProject.getBuild().getDirectory(), "mule" + i);
            buildDirectory.mkdir();
            File home = this.doInstallMule(buildDirectory);
            controllers.add(new MuleProcessController(home.getAbsolutePath(), this.timeout));
            muleHomes[i] = home;
        }
        if (this.application == null) {
            this.initializeApplication();
            try {
                File destApplication = new File(this.application.getParentFile(), this.applicationName + ".zip");
                FileUtils.copyFile((File)this.application, (File)destApplication);
                this.application = destApplication;
            }
            catch (IOException e) {
                throw new MojoFailureException("Couldn't rename [" + this.application + "] to [" + this.applicationName + "]");
            }
        } else {
            this.initializeApplication();
        }
        if (null != this.script) {
            this.executeGroovyScript();
        }
        new ClusterDeployer(muleHomes, controllers, this.getLog(), this.application, this.deploymentTimeout, this.arguments, 1000L).addLibraries(this.libs).execute();
    }

    private void validateSize() throws MojoFailureException {
        if (this.size > MAX_CLUSTER_SIZE) {
            throw new MojoFailureException("Cannot create cluster with more than 8 nodes");
        }
    }

    public void standalone() throws MojoExecutionException, MojoFailureException {
        File muleHome = this.installMule(new File(this.mavenProject.getBuild().getDirectory()));
        MuleProcessController mule = new MuleProcessController(muleHome.getAbsolutePath(), this.timeout);
        if (this.application == null) {
            this.initializeApplication();
            try {
                File destApplication = new File(this.application.getParentFile(), this.applicationName + ".zip");
                FileUtils.copyFile((File)this.application, (File)destApplication);
                this.application = destApplication;
            }
            catch (IOException e) {
                throw new MojoFailureException("Couldn't rename [" + this.application + "] to [" + this.applicationName + "]");
            }
        } else {
            this.initializeApplication();
        }
        Deployer deployer = new Deployer(mule, this.getLog(), this.application, this.deploymentTimeout, this.arguments, 1000L).addLibraries(this.libs);
        this.addDomain(deployer);
        this.addDependencies(deployer);
        if (null != this.script) {
            this.executeGroovyScript();
        }
        deployer.execute();
    }

    private File installMule(File buildDirectory) throws MojoExecutionException, MojoFailureException {
        if (this.muleHome == null) {
            this.muleHome = this.doInstallMule(buildDirectory);
        }
        this.mavenProject.getProperties().setProperty("mule.home", this.muleHome.getAbsolutePath());
        this.getLog().info((CharSequence)("Using MULE_HOME: " + this.muleHome));
        return this.muleHome;
    }

    private File doInstallMule(File buildDirectory) throws MojoExecutionException, MojoFailureException {
        if (this.muleDistribution == null) {
            if (this.community) {
                this.muleDistribution = new ArtifactDescription("org.mule.distributions", "mule-standalone", this.muleVersion, "tar.gz");
                this.getLog().debug((CharSequence)("muleDistribution not set, using default community artifact: " + this.muleDistribution));
            } else {
                this.muleDistribution = new ArtifactDescription("com.mulesoft.muleesb.distributions", "mule-ee-distribution-standalone", this.muleVersion, "tar.gz");
                this.getLog().debug((CharSequence)("muleDistribution not set, using default artifact: " + this.muleDistribution));
            }
        }
        this.unpackMule(this.muleDistribution, buildDirectory);
        return new File(buildDirectory, this.muleDistribution.getContentDirectory());
    }

    private void unpackMule(ArtifactDescription muleDistribution, File destDir) throws MojoExecutionException, MojoFailureException {
        File src = this.getDependency(muleDistribution);
        this.getLog().info((CharSequence)("Copying " + src.getAbsolutePath() + " to " + destDir.getAbsolutePath()));
        this.extract(src, destDir, muleDistribution.getType());
    }

    private void extract(File src, File dest, String type) throws MojoExecutionException, MojoFailureException {
        try {
            UnArchiver unArchiver = this.getArchiver(type);
            unArchiver.setSourceFile(src);
            unArchiver.setDestDirectory(dest);
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Couldn't extract file " + src + " to " + dest);
        }
        catch (Exception e) {
            throw new MojoFailureException("Couldn't extract file " + src + " to " + dest);
        }
    }

    private UnArchiver getArchiver(String type) throws MojoExecutionException {
        UnArchiver unArchiver;
        try {
            unArchiver = this.archiverManager.getUnArchiver(type);
            this.getLog().debug((CharSequence)("Found unArchiver by extension: " + unArchiver));
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Couldn't find archiver for type: " + type);
        }
        return unArchiver;
    }

    private void verify(boolean exists, String message) throws MojoFailureException {
        if (!exists) {
            throw new MojoFailureException(message);
        }
    }
}

