/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.mule.agent;

import java.io.File;
import java.io.InputStream;
import java.security.KeyStore;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.mule.tools.mule.ApiException;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;

public class AgentApi {
    public static final String APPLICATIONS_PATH = "/mule/applications/";
    private final String uri;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final String trustStoreType;

    public AgentApi(String uri, String trustStorePath, String trustStorePassword, String trustStoreType) {
        this.uri = uri;
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
        this.trustStoreType = trustStoreType;
    }

    public void deployApplication(String applicationName, File file) {
        Client client = this.getClient();
        WebTarget target = client.target(this.uri).path(APPLICATIONS_PATH + applicationName);
        Response response = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.entity((Object)file, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE));
        if (response.getStatus() != 202) {
            String message = (String)response.readEntity(String.class);
            throw new ApiException(message, response.getStatusInfo().getStatusCode(), response.getStatusInfo().getReasonPhrase());
        }
    }

    public void undeployApplication(String appName) {
        Client client = this.getClient();
        WebTarget target = client.target(this.uri).path(APPLICATIONS_PATH + appName);
        Response response = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete();
        if (response.getStatus() != 202) {
            String message = (String)response.readEntity(String.class);
            throw new ApiException(message, response.getStatusInfo().getStatusCode(), response.getStatusInfo().getReasonPhrase());
        }
    }

    private Client getClient() {
        ClientBuilder builder = ClientBuilder.newBuilder();
        if (StringUtils.isNotEmpty((String)this.trustStorePath)) {
            try {
                KeyStore trustStore = KeyStore.getInstance(this.trustStoreType);
                InputStream is = IOUtils.getResourceAsStream((String)this.trustStorePath, this.getClass());
                if (null == is) {
                    throw new RuntimeException("Cannot find trust store file " + this.trustStorePath);
                }
                trustStore.load(is, this.trustStorePassword.toCharArray());
                builder.trustStore(trustStore);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot load trust store file " + this.trustStorePath, e);
            }
        }
        return builder.build();
    }
}

