/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.mule.agent;

import java.io.File;
import org.apache.maven.plugin.logging.Log;
import org.mule.tools.mule.AbstractDeployer;
import org.mule.tools.mule.ApiException;
import org.mule.tools.mule.DeploymentException;
import org.mule.tools.mule.agent.AgentApi;

public class AgentDeployer
extends AbstractDeployer {
    private final AgentApi agentApi;
    private final Log log;
    private final String applicationName;

    public AgentDeployer(Log log, String applicationName, File application, String uri, String trustStorePath, String trustStorePassword, String trustStoreType) {
        super(application);
        this.applicationName = applicationName;
        this.agentApi = new AgentApi(uri, trustStorePath, trustStorePassword, trustStoreType);
        this.log = log;
    }

    @Override
    protected String deployApplication(File file) throws DeploymentException {
        try {
            this.log.info((CharSequence)("Deploying application " + file.getName() + " to Mule Agent"));
            this.agentApi.deployApplication(this.applicationName, file);
        }
        catch (ApiException e) {
            this.log.error((CharSequence)("Failure: " + e.getMessage()));
            throw e;
        }
        return file.getName();
    }

    @Override
    protected void undeployApplication(String id) {
        this.log.info((CharSequence)("Undeploying application " + id + " from Mule Agent"));
        this.agentApi.undeployApplication(id);
    }
}

