/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.mule.arm;

import java.io.File;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.mule.tools.mule.AbstractMuleApi;
import org.mule.tools.mule.TargetType;
import org.mule.tools.mule.arm.Application;
import org.mule.tools.mule.arm.Applications;
import org.mule.tools.mule.arm.Target;
import org.mule.tools.mule.arm.Targets;

public class ArmApi
extends AbstractMuleApi {
    private static final String APPLICATIONS = "/hybrid/api/v1/applications";
    private static final String SERVERS = "/hybrid/api/v1/servers";
    private static final String SERVER_GROUPS = "/hybrid/api/v1/serverGroups";
    private static final String CLUSTERS = "/hybrid/api/v1/clusters";
    private String uri;

    public ArmApi(String uri, String username, String password, String environment) {
        super(username, password, environment);
        this.uri = uri;
    }

    public Boolean isStarted(int applicationId) {
        Application application = this.getApplicationStatus(applicationId);
        return "STARTED".equals(application.data.lastReportedStatus);
    }

    public Application getApplicationStatus(int applicationId) {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(this.uri).path("/hybrid/api/v1/applications/" + applicationId);
        return (Application)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).headers(this.authorizationHeader()).get(Application.class);
    }

    public String undeployApplication(int applicationId) {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(this.uri).path("/hybrid/api/v1/applications/" + applicationId);
        return (String)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).headers(this.authorizationHeader()).delete(String.class);
    }

    public Application deployApplication(File app, String appName, TargetType targetType, String target) {
        String id = this.getId(targetType, target);
        Client client = (Client)ClientBuilder.newClient().register(MultiPartFeature.class);
        WebTarget webTarget = client.target(this.uri).path(APPLICATIONS);
        FileDataBodyPart applicationPart = new FileDataBodyPart("file", app);
        MultiPart multipart = new FormDataMultiPart().field("artifactName", appName).field("targetId", id).bodyPart((BodyPart)applicationPart);
        return (Application)webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).headers(this.authorizationHeader()).post(Entity.entity((Object)multipart, (MediaType)multipart.getMediaType()), Application.class);
    }

    private String getId(TargetType targetType, String target) {
        String id = null;
        switch (targetType) {
            case server: {
                id = this.findServerByName((String)target).id;
                break;
            }
            case serverGroup: {
                id = this.findServerGroupByName((String)target).id;
                break;
            }
            case cluster: {
                id = this.findClusterByName((String)target).id;
            }
        }
        return id;
    }

    public Applications getApplications() {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(this.uri).path(APPLICATIONS);
        return (Applications)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).headers(this.authorizationHeader()).get(Applications.class);
    }

    public Target findServerByName(String name) {
        return this.findTargetByName(name, SERVERS);
    }

    public Target findServerGroupByName(String name) {
        return this.findTargetByName(name, SERVER_GROUPS);
    }

    public Target findClusterByName(String name) {
        return this.findTargetByName(name, CLUSTERS);
    }

    private Target findTargetByName(String name, String path) {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(this.uri).path(path);
        Targets response = (Targets)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).headers(this.authorizationHeader()).get(Targets.class);
        for (int i = 0; i < response.data.length; ++i) {
            if (!name.equals(response.data[i].name)) continue;
            return response.data[i];
        }
        throw new RuntimeException("Couldn't find target named [" + name + "]");
    }
}

