/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.mule.cloudhub;

import java.io.File;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.mule.tools.mule.AbstractMuleApi;
import org.mule.tools.mule.ApiException;
import org.mule.tools.mule.cloudhub.Application;
import org.mule.tools.mule.cloudhub.CreateApplicationRequest;
import org.mule.tools.mule.cloudhub.UpdateApplicationRequest;

public class CloudhubApi
extends AbstractMuleApi {
    public static final String URI = "https://anypoint.mulesoft.com";
    public static final String APPLICATIONS_PATH = "/cloudhub/api/applications";
    public static final String APPLICATION_UPDATE_PATH = "/cloudhub/api/v2/applications/%s";
    public static final String APPLICATIONS_FILES_PATH = "/cloudhub/api/v2/applications/%s/files";
    public static final String DOMAINS_PATH = "/cloudhub/api/applications/domains/";

    public CloudhubApi(String username, String password, String environment) {
        super(username, password, environment);
    }

    public Application createApplication(String appName, String region, String muleVersion, int workers, String workerType) {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(URI).path(APPLICATIONS_PATH);
        CreateApplicationRequest application = new CreateApplicationRequest(appName, region, muleVersion, workers, workerType);
        Response response = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).headers(this.authorizationHeader()).post(Entity.entity((Object)application, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        if (response.getStatus() == 201) {
            return (Application)response.readEntity(Application.class);
        }
        String message = (String)response.readEntity(String.class);
        throw new ApiException(message, response.getStatusInfo().getStatusCode(), response.getStatusInfo().getReasonPhrase());
    }

    public void updateApplication(String appName, String region, String muleVersion, int workers, String workerType) {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(URI).path(String.format(APPLICATION_UPDATE_PATH, appName));
        UpdateApplicationRequest application = new UpdateApplicationRequest(region, muleVersion, workers, workerType);
        Response response = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).headers(this.authorizationHeader()).put(Entity.entity((Object)application, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        if (response.getStatus() != 200 && response.getStatus() != 301) {
            String message = (String)response.readEntity(String.class);
            throw new ApiException(message, response.getStatusInfo().getStatusCode(), response.getStatusInfo().getReasonPhrase());
        }
    }

    public Application getApplication(String appName) {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(URI).path("/cloudhub/api/applications/" + appName);
        Response response = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).headers(this.authorizationHeader()).get();
        if (response.getStatus() == 200) {
            return (Application)response.readEntity(Application.class);
        }
        if (response.getStatus() == 404) {
            return null;
        }
        String message = (String)response.readEntity(String.class);
        throw new ApiException(message, response.getStatusInfo().getStatusCode(), response.getStatusInfo().getReasonPhrase());
    }

    public void uploadFile(String appName, File file) {
        Client client = (Client)ClientBuilder.newClient().register(MultiPartFeature.class);
        WebTarget target = client.target(URI).path(String.format(APPLICATIONS_FILES_PATH, appName));
        FileDataBodyPart applicationPart = new FileDataBodyPart("file", file);
        MultiPart multipart = new FormDataMultiPart().bodyPart((BodyPart)applicationPart);
        Response response = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).headers(this.authorizationHeader()).post(Entity.entity((Object)multipart, (MediaType)multipart.getMediaType()));
        if (response.getStatus() != 200) {
            String message = (String)response.readEntity(String.class);
            throw new ApiException(message, response.getStatusInfo().getStatusCode(), response.getStatusInfo().getReasonPhrase());
        }
    }

    public void startApplication(String appName) {
        this.changeApplicationState(appName, "START");
    }

    public void stopApplication(String appName) {
        this.changeApplicationState(appName, "STOP");
    }

    private void changeApplicationState(String appName, String state) {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(URI).path("/cloudhub/api/applications/" + appName + "/status");
        Entity json = Entity.json((Object)("{\"status\": \"" + state + "\"}"));
        Response response = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).headers(this.authorizationHeader()).post(json);
        if (response.getStatus() != 200 && response.getStatus() != 304) {
            String message = (String)response.readEntity(String.class);
            throw new ApiException(message, response.getStatusInfo().getStatusCode(), response.getStatusInfo().getReasonPhrase());
        }
    }

    public void deleteApplication(String appName) {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(URI).path("/cloudhub/api/applications/" + appName);
        Response response = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).headers(this.authorizationHeader()).delete();
        if (response.getStatus() != 200 && response.getStatus() != 204) {
            String message = (String)response.readEntity(String.class);
            throw new ApiException(message, response.getStatusInfo().getStatusCode(), response.getStatusInfo().getReasonPhrase());
        }
    }

    public boolean isNameAvailable(String appName) {
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(URI).path(DOMAINS_PATH + appName);
        Response response = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).headers(this.authorizationHeader()).get();
        if (response.getStatus() == 200) {
            DomainAvailability availability = (DomainAvailability)response.readEntity(DomainAvailability.class);
            return availability.available;
        }
        String message = (String)response.readEntity(String.class);
        throw new ApiException(message, response.getStatusInfo().getStatusCode(), response.getStatusInfo().getReasonPhrase());
    }

    private static class DomainAvailability {
        public boolean available;

        private DomainAvailability() {
        }
    }
}

