/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.mule.cloudhub;

import java.io.File;
import org.apache.maven.plugin.logging.Log;
import org.mule.tools.mule.AbstractDeployer;
import org.mule.tools.mule.ApiException;
import org.mule.tools.mule.DeploymentException;
import org.mule.tools.mule.cloudhub.CloudhubApi;
import org.mule.util.FilenameUtils;

public class CloudhubDeployer
extends AbstractDeployer {
    private final CloudhubApi cloudhubApi;
    private final boolean redeploy;
    private final String region;
    private final String muleVersion;
    private final int workers;
    private final String workerType;
    private final Log log;

    public CloudhubDeployer(String username, String password, String environment, File applications, boolean redeploy, String region, String muleVersion, int workers, String workerType, Log log) {
        super(applications);
        this.cloudhubApi = new CloudhubApi(username, password, environment);
        this.redeploy = redeploy;
        this.region = region;
        this.muleVersion = muleVersion;
        this.workers = workers;
        this.workerType = workerType;
        this.log = log;
    }

    @Override
    protected void init() {
        this.cloudhubApi.init();
    }

    @Override
    protected String deployApplication(File file) throws DeploymentException {
        String appName = FilenameUtils.getBaseName((String)file.getName());
        this.log.info((CharSequence)("Deploying application " + appName + " to Cloudhub"));
        try {
            boolean domainAvailable = this.cloudhubApi.isNameAvailable(appName);
            if (domainAvailable) {
                this.log.info((CharSequence)("Creating application " + appName));
                this.cloudhubApi.createApplication(appName, this.region, this.muleVersion, this.workers, this.workerType);
            } else if (this.redeploy) {
                this.log.info((CharSequence)("Application " + appName + " already exists, redeploying"));
                this.cloudhubApi.updateApplication(appName, this.region, this.muleVersion, this.workers, this.workerType);
            } else {
                this.log.error((CharSequence)("Application " + appName + " already exists, but redeploy=false. Aborting."));
                throw new DeploymentException("Application " + appName + " already exists");
            }
            this.log.info((CharSequence)("Uploading application contents " + appName));
            this.cloudhubApi.uploadFile(appName, file);
            this.log.info((CharSequence)("Starting application " + appName));
            this.cloudhubApi.startApplication(appName);
        }
        catch (ApiException e) {
            this.log.error((CharSequence)("Failed: " + e.getMessage()));
            throw e;
        }
        return appName;
    }

    @Override
    protected void undeployApplication(String id) {
        this.cloudhubApi.deleteApplication(id);
    }
}

