/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.scaffolder.declaration.builders;

import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.SourceElementDeclaration;

import static org.mule.runtime.app.declaration.api.fluent.ElementDeclarer.newParameterGroup;
import static org.mule.soapkit.scaffolder.declaration.ElementDeclarers.HTTP_ELEMENT_DECLARER;
import static org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel.CONNECTION;

public class HttpArtifactDeclarationBuilder {

  private static final String PARAMETER_PATH = "path";
  public static final String PARAMETER_HOST = "host";
  public static final String PARAMETER_PORT = "port";
  public static final String PARAMETER_BODY = "body";
  public static final String PARAMETER_HEADERS = "headers";
  public static final String PARAMETER_STATUS = "statusCode";

  private static final String SOURCE_TAG_NAME = "listener";
  private static final String CONNECTION_TAG_NAME = "listener";
  public static final String LISTENER_CONFIGURATION_TAG_NAME = "listenerConfig";

  private HttpArtifactDeclarationBuilder() {}

  public static SourceElementDeclaration buildHttpListenerSource(String httpListenerConfig, String path) {
    return HTTP_ELEMENT_DECLARER.newSource(SOURCE_TAG_NAME)
        .withConfig(httpListenerConfig)
        .withParameterGroup(newParameterGroup()
            .withParameter(PARAMETER_PATH, path)
            .getDeclaration())
        .withParameterGroup(newParameterGroup("Response")
            .withParameter(PARAMETER_STATUS, "#[attributes.additionalTransportData.statusCode default 200]")
            .withParameter(PARAMETER_BODY, "#[payload]")
            .withParameter(PARAMETER_HEADERS, "#[attributes.protocolHeaders default {}]")
            .getDeclaration())
        .withParameterGroup(newParameterGroup("Error Response")
            .withParameter(PARAMETER_STATUS, "#[attributes.additionalTransportData.statusCode default 500]")
            .withParameter(PARAMETER_BODY, "#[payload]")
            .withParameter(PARAMETER_HEADERS, "#[attributes.protocolHeaders default {}]")
            .getDeclaration())
        .getDeclaration();
  }

  public static ConfigurationElementDeclaration buildHttpListenerConfig(String basePath,
                                                                        ConnectionElementDeclaration connection) {
    return HTTP_ELEMENT_DECLARER.newConfiguration(LISTENER_CONFIGURATION_TAG_NAME)
        .withRefName("api-httpListenerConfig")
        .withConnection(connection)
        .getDeclaration();
  }

  public static ConnectionElementDeclaration buildHttpListenerConnection(String host, String port) {
    return HTTP_ELEMENT_DECLARER.newConnection(CONNECTION_TAG_NAME)
        .withParameterGroup(newParameterGroup(CONNECTION)
            .withParameter(PARAMETER_HOST, host)
            .withParameter(PARAMETER_PORT, port)
            .getDeclaration())
        .getDeclaration();
  }
}
