/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.scaffolder.model;

import org.mule.runtime.app.declaration.api.ConstructElementDeclaration;
import org.mule.runtime.app.declaration.api.OperationElementDeclaration;

import static java.util.Collections.singletonList;
import static org.mule.soapkit.scaffolder.declaration.builders.MuleArtifactDeclarationBuilder.buildFlow;
import static org.mule.soapkit.scaffolder.declaration.builders.MuleArtifactDeclarationBuilder.buildSetPayload;

public class Flow implements MuleElement<ConstructElementDeclaration> {

  private static String getDefaultText(final String flowName) {
    return "%dw 2.0\n" +
        "output application/java\n" +
        "ns soap http://schemas.xmlsoap.org/soap/envelope\n" +
        // "ns soap http://www.w3.org/2003/05/soap-envelope\n" + SOAP Version 1.2
        "---\n" +
        "{\n" +
        "    body: {\n" +
        "        soap#Fault: {\n" +
        "            faultcode: \"soap:Server\",\n" +
        "            faultstring: \"Operation [" + flowName + "] not implemented\"\n" +
        "        }\n" +
        "    } write \"application/xml\"\n" +
        "}";
  }

  protected ConstructElementDeclaration declaration;

  public Flow(String flowName) {
    this(defaultFlowDeclaration(flowName));
  }

  public Flow(ConstructElementDeclaration declaration) {
    this.declaration = declaration;
  }

  @Override
  public String getName() {
    return declaration.getRefName();
  }

  @Override
  public ConstructElementDeclaration getDeclaration() {
    return declaration;
  }

  private static ConstructElementDeclaration defaultFlowDeclaration(String flowName) {
    final OperationElementDeclaration setPayload = buildSetPayload(getDefaultText(flowName));
    return buildFlow(flowName, singletonList(setPayload));
  }
}
