/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.scaffolder.model;

import org.apache.commons.lang3.math.NumberUtils;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.soapkit.scaffolder.declaration.builders.HttpArtifactDeclarationBuilder;
import org.mule.soapkit.scaffolder.model.MuleElement;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;

public class HttpListenerConfig
implements MuleElement<ConfigurationElementDeclaration> {
    static final String DEFAULT_PORT = "8081";
    static final String DEFAULT_HOST = "0.0.0.0";
    private HttpListenerConnection httpConnection;
    private ConfigurationElementDeclaration declaration;

    public HttpListenerConfig() {
        this((String)null);
    }

    public HttpListenerConfig(String basePath) {
        this(HttpArtifactDeclarationBuilder.buildHttpListenerConfig(basePath, new HttpListenerConnection().declaration));
    }

    public HttpListenerConfig(ConfigurationElementDeclaration declaration) {
        this.declaration = declaration;
    }

    @Override
    public String getName() {
        return this.declaration.getRefName();
    }

    @Override
    public ConfigurationElementDeclaration getDeclaration() {
        return this.declaration;
    }

    private HttpListenerConnection getHttpConnection() {
        if (this.httpConnection == null) {
            this.httpConnection = this.declaration.getConnection().map(HttpListenerConnection::new).orElse(new HttpListenerConnection());
        }
        return this.httpConnection;
    }

    public String getHost() {
        return this.getHttpConnection().getHost();
    }

    public int getPort() {
        return NumberUtils.toInt((String)this.getHttpConnection().getPort(), (int)0);
    }

    private static class HttpListenerConnection {
        private ConnectionElementDeclaration declaration;

        HttpListenerConnection() {
            this(HttpListenerConfig.DEFAULT_HOST, HttpListenerConfig.DEFAULT_PORT);
        }

        HttpListenerConnection(String host, String port) {
            this(HttpArtifactDeclarationBuilder.buildHttpListenerConnection(host, port));
        }

        HttpListenerConnection(ConnectionElementDeclaration declaration) {
            this.declaration = declaration;
        }

        public String getHost() {
            return this.getParameterValue("host");
        }

        public String getPort() {
            return this.getParameterValue("port");
        }

        private String getParameterValue(String parameter) {
            return this.declaration.getParameterGroup(ParameterGroupModel.CONNECTION).flatMap(pg -> pg.getParameter(parameter)).map(pd -> pd.getValue().toString()).orElse(null);
        }
    }
}

