/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.scaffolder.model;

import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.soapkit.scaffolder.declaration.builders.SoapkitArtifactDeclarationBuilder;
import org.mule.soapkit.scaffolder.model.MuleElement;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;

public class SoapkitConfig
implements MuleElement<ConfigurationElementDeclaration> {
    public static final String SOAPKIT_CONFIG_NAME = "soapkit-config";
    private ConfigurationElementDeclaration declaration;

    public SoapkitConfig(String wsdlPath, String service, String port) {
        this(SOAPKIT_CONFIG_NAME, wsdlPath, service, port);
    }

    public SoapkitConfig(String name, String wsdlPath, String service, String port) {
        this(SoapkitArtifactDeclarationBuilder.buildSoapkitConfig(name, wsdlPath, service, port));
    }

    public SoapkitConfig(ConfigurationElementDeclaration declaration) {
        this.declaration = declaration;
    }

    @Override
    public String getName() {
        return this.declaration.getRefName();
    }

    @Override
    public ConfigurationElementDeclaration getDeclaration() {
        return this.declaration;
    }

    public String getPort() {
        return SoapkitConfig.getConnectionParameterValue(this.declaration, "port");
    }

    public String getService() {
        return SoapkitConfig.getConnectionParameterValue(this.declaration, "service");
    }

    public String getWsdlPath() {
        return SoapkitConfig.getConnectionParameterValue(this.declaration, "wsdlLocation");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoapkitConfig)) {
            return false;
        }
        SoapkitConfig that = (SoapkitConfig)o;
        return this.getPort() != null && this.getPort().equals(that.getPort()) && this.getService() != null && this.getService().equals(that.getService()) && this.getWsdlPath() != null && this.getWsdlPath().equals(that.getWsdlPath());
    }

    private static String getConnectionParameterValue(ConfigurationElementDeclaration declaration, String parameter) {
        return declaration.getParameterGroups().stream().filter(pged -> ParameterGroupModel.CONNECTION.equals(pged.getName())).flatMap(pged -> pged.getParameters().stream().filter(p -> parameter.equals(p.getName()))).map(p -> p.getValue().toString()).findFirst().orElse(null);
    }
}

