/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.scaffolder.model.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.soapkit.scaffolder.declaration.builders.MuleArtifactDeclarationBuilder;
import org.mule.soapkit.scaffolder.model.Flow;
import org.mule.soapkit.scaffolder.model.HttpListenerConfig;
import org.mule.soapkit.scaffolder.model.MuleElement;
import org.mule.soapkit.scaffolder.model.SoapkitConfig;

public class MuleConfigBuilder {
    private ArtifactDeclaration document;
    private SoapkitConfig config;
    private List<HttpListenerConfig> httpListenerConfigs = Collections.emptyList();
    private List<Flow> flows = Collections.emptyList();

    public MuleConfigBuilder() {
        this(MuleArtifactDeclarationBuilder.emptyArtifactDeclaration());
    }

    public MuleConfigBuilder(ArtifactDeclaration document) {
        this.document = document;
        this.config = null;
        this.flows = new ArrayList<Flow>();
        this.httpListenerConfigs = new ArrayList<HttpListenerConfig>();
    }

    public MuleConfigBuilder withConfig(SoapkitConfig config) {
        this.config = config;
        return this;
    }

    public MuleConfigBuilder withHttpListeners(List<HttpListenerConfig> httpListenerConfigs) {
        this.httpListenerConfigs.addAll(httpListenerConfigs);
        return this;
    }

    public MuleConfigBuilder withFlows(List<Flow> flows) {
        this.flows.addAll(flows);
        return this;
    }

    public ArtifactDeclaration build() {
        this.removeSchemaLocationProperty();
        this.httpListenerConfigs.forEach(this::addToDocument);
        Optional.ofNullable(this.config).ifPresent(this::addToDocument);
        this.flows.forEach(this::addToDocument);
        return this.document;
    }

    private void addToDocument(MuleElement element) {
        this.document.addGlobalElement((GlobalElementDeclaration)element.getDeclaration());
    }

    private void removeSchemaLocationProperty() {
        this.document.getCustomConfigurationParameters().removeIf(p -> "xsi:schemaLocation".equals(p.getName()));
    }
}

