/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.scaffolder.declaration.builders;

import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConstructElementDeclaration;
import org.mule.runtime.app.declaration.api.OperationElementDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ConstructElementDeclarer;

import java.util.List;

import static org.mule.runtime.app.declaration.api.fluent.ElementDeclarer.newArtifact;
import static org.mule.runtime.app.declaration.api.fluent.ElementDeclarer.newObjectValue;
import static org.mule.runtime.app.declaration.api.fluent.ElementDeclarer.newParameterGroup;
import static org.mule.soapkit.scaffolder.declaration.ElementDeclarers.CORE_ELEMENT_DECLARER;
import static org.mule.soapkit.scaffolder.declaration.ElementDeclarers.EE_ELEMENT_DECLARER;

public class MuleArtifactDeclarationBuilder {

  public static final String FLOW_TAG_NAME = "flow";

  public static ArtifactDeclaration emptyArtifactDeclaration() {
    return newArtifact().getDeclaration();
  }

  public static ConstructElementDeclaration buildFlow(String flowName, List<ComponentElementDeclaration> components) {
    final ConstructElementDeclarer flowDeclarer = CORE_ELEMENT_DECLARER.newConstruct(FLOW_TAG_NAME).withRefName(flowName);
    components.forEach(flowDeclarer::withComponent);

    return flowDeclarer.getDeclaration();
  }

  public static OperationElementDeclaration buildSetPayload(String payload) {
    return EE_ELEMENT_DECLARER.newOperation("transform")
        .withParameterGroup(newParameterGroup("Message")
            .withParameter("setPayload", newObjectValue()
                .withParameter("script", payload)
                .build())
            .getDeclaration())
        .getDeclaration();
  }

}
