/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.scaffolder.declaration.builders;

import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.OperationElementDeclaration;

import static org.mule.runtime.app.declaration.api.fluent.ElementDeclarer.newParameterGroup;
import static org.mule.soapkit.scaffolder.declaration.ElementDeclarers.SOAPKIT_ELEMENT_DECLARER;
import static org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel.CONNECTION;
import static org.apache.commons.lang3.SystemUtils.IS_OS_WINDOWS;

public class SoapkitArtifactDeclarationBuilder {

  public static final String PARAMETER_PORT = "port";
  public static final String PARAMETER_SERVICE = "service";
  public static final String PARAMETER_WSDL_LOCATION = "wsdlLocation";
  public static final String PARAMETER_HTTP_STATUS_VAR_NAME = "httpStatusVarName";

  public static final String CONFIGURATION_TAG_NAME = "config";
  public static final String HTTP_STATUS_VAR_NAME = "httpStatus";

  private SoapkitArtifactDeclarationBuilder() {}

  public static ConfigurationElementDeclaration buildSoapkitConfig(String name, String wsdlLocation, String service,
                                                                   String port) {
    return SOAPKIT_ELEMENT_DECLARER.newConfiguration(CONFIGURATION_TAG_NAME)
        .withRefName(name)
        .withParameterGroup(newParameterGroup(CONNECTION)
            .withParameter(PARAMETER_WSDL_LOCATION, toPlatformIndependentPath(wsdlLocation))
            .withParameter(PARAMETER_SERVICE, service)
            .withParameter(PARAMETER_PORT, port)
            .getDeclaration())
        .withParameterGroup(newParameterGroup()
            .withParameter(PARAMETER_HTTP_STATUS_VAR_NAME, HTTP_STATUS_VAR_NAME)
            .getDeclaration())
        .getDeclaration();
  }

  private static String toPlatformIndependentPath(String wsdlLocation) {
    if (IS_OS_WINDOWS)
      return wsdlLocation.replace("\\", "/");

    return wsdlLocation;
  }

  public static OperationElementDeclaration buildSoapkitRouterOperation(String soapkitConfig) {
    return SOAPKIT_ELEMENT_DECLARER.newOperation("router")
        .withConfig(soapkitConfig)
        .withParameterGroup(newParameterGroup()
            .withParameter("message", "#[payload]")
            .withParameter("attributes", "#[\n" +
                "              %dw 2.0\n" +
                "              output application/java\n" +
                "              ---\n" +
                "              {\n" +
                "                  headers: attributes.headers,\n" +
                "                  method: attributes.method,\n" +
                "                  queryString: attributes.queryString\n" +
                "            }]")
            .getDeclaration())
        .getDeclaration();
  }

}
