/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.scaffolder.model;

import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;

import java.util.List;
import java.util.stream.Collectors;

import static org.mule.soapkit.scaffolder.declaration.builders.HttpArtifactDeclarationBuilder.LISTENER_CONFIGURATION_TAG_NAME;
import static org.mule.soapkit.scaffolder.declaration.builders.MuleArtifactDeclarationBuilder.emptyArtifactDeclaration;

public class MuleDomain implements MuleElement<ArtifactDeclaration> {

  private ArtifactDeclaration artifactDeclaration;

  public MuleDomain(ArtifactDeclaration domain) {
    artifactDeclaration = domain != null ? domain : emptyArtifactDeclaration();
  }

  public List<HttpListenerConfig> httpListenerConfigs() {
    return artifactDeclaration.getGlobalElements().stream()
        .filter(ged -> LISTENER_CONFIGURATION_TAG_NAME.equals(ged.getName()))
        .map(ged -> (ConfigurationElementDeclaration) ged)
        .map(HttpListenerConfig::new)
        .collect(Collectors.toList());
  }

  @Override
  public String getName() {
    return getDeclaration().getName();
  }

  @Override
  public ArtifactDeclaration getDeclaration() {
    return artifactDeclaration;
  }
}
