/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.scaffolder.model;

import com.google.common.collect.Ordering;
import org.mule.runtime.app.declaration.api.ConstructElementDeclaration;
import org.mule.runtime.app.declaration.api.OperationElementDeclaration;
import org.mule.runtime.app.declaration.api.SourceElementDeclaration;

import java.util.List;

import static java.util.Arrays.asList;
import static org.mule.soapkit.scaffolder.declaration.builders.HttpArtifactDeclarationBuilder.buildHttpListenerSource;
import static org.mule.soapkit.scaffolder.declaration.builders.MuleArtifactDeclarationBuilder.buildFlow;
import static org.mule.soapkit.scaffolder.declaration.builders.SoapkitArtifactDeclarationBuilder.buildSoapkitRouterOperation;

public class SoapkitFlow extends Flow {

  private static final String DEFAULT_FLOW_NAME = "api-main";
  private final static String DEFAULT_HTTP_LISTENER_NAME = "api-httpListenerConfig";

  public SoapkitFlow(SoapkitConfig config, List<HttpListenerConfig> httpListenerConfigs) {
    super(buildDeclaration(config, httpListenerConfigs));
  }

  private static ConstructElementDeclaration buildDeclaration(SoapkitConfig config,
                                                              List<HttpListenerConfig> httpListenerConfigs) {
    final String listenerConfigName = getHttpListenerConfigName(httpListenerConfigs);
    final SourceElementDeclaration source = buildHttpListenerSource(listenerConfigName, buildServicePath(config));
    final OperationElementDeclaration router = buildSoapkitRouterOperation(config.getName());
    return buildFlow(DEFAULT_FLOW_NAME, asList(source, router));
  }

  private static String getHttpListenerConfigName(List<HttpListenerConfig> httpListenerConfigs) {
    return Ordering.natural()
        .onResultOf(HttpListenerConfig::getPort)
        .nullsLast()
        .immutableSortedCopy(httpListenerConfigs).stream()
        .findFirst()
        .map(HttpListenerConfig::getName)
        .orElse(DEFAULT_HTTP_LISTENER_NAME);
  }

  private static String buildServicePath(SoapkitConfig config) {
    return String.format("/%s/%s", config.getService(), config.getPort());
  }
}
