/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.scaffolder.model.builders;

import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.soapkit.scaffolder.model.Flow;
import org.mule.soapkit.scaffolder.model.HttpListenerConfig;
import org.mule.soapkit.scaffolder.model.MuleElement;
import org.mule.soapkit.scaffolder.model.SoapkitConfig;

import java.util.ArrayList;
import java.util.List;

import static java.util.Collections.emptyList;
import static java.util.Optional.ofNullable;
import static org.mule.soapkit.scaffolder.declaration.builders.MuleArtifactDeclarationBuilder.emptyArtifactDeclaration;

public class MuleConfigBuilder {

  private ArtifactDeclaration document;
  private SoapkitConfig config;
  private List<HttpListenerConfig> httpListenerConfigs = emptyList();
  private List<Flow> flows = emptyList();

  public MuleConfigBuilder() {
    this(emptyArtifactDeclaration());
  }

  public MuleConfigBuilder(ArtifactDeclaration document) {
    this.document = document;
    this.config = null;
    this.flows = new ArrayList<>();
    this.httpListenerConfigs = new ArrayList<>();
  }

  public MuleConfigBuilder withConfig(SoapkitConfig config) {
    this.config = config;
    return this;
  }

  public MuleConfigBuilder withHttpListeners(List<HttpListenerConfig> httpListenerConfigs) {
    this.httpListenerConfigs.addAll(httpListenerConfigs);
    return this;
  }

  public MuleConfigBuilder withFlows(List<Flow> flows) {
    this.flows.addAll(flows);
    return this;
  }

  public ArtifactDeclaration build() {
    removeSchemaLocationProperty();
    httpListenerConfigs.forEach(this::addToDocument);
    ofNullable(config).ifPresent(this::addToDocument);
    flows.forEach(this::addToDocument);
    return document;
  }

  private void addToDocument(MuleElement element) {
    document.addGlobalElement((GlobalElementDeclaration) element.getDeclaration());
  }

  //hack to refresh schemaLocation
  private void removeSchemaLocationProperty() {
    document.getCustomConfigurationParameters().removeIf(p -> "xsi:schemaLocation".equals(p.getName()));
  }

}
