/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.scaffolder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.soapkit.scaffolder.model.Flow;
import org.mule.soapkit.scaffolder.model.HttpListenerConfig;
import org.mule.soapkit.scaffolder.model.MuleConfig;
import org.mule.soapkit.scaffolder.model.MuleDomain;
import org.mule.soapkit.scaffolder.model.SoapkitConfig;
import org.mule.soapkit.scaffolder.model.SoapkitFlow;
import org.mule.soapkit.scaffolder.model.builders.MuleConfigBuilder;
import org.mule.soapkit.scaffolder.parsers.WsdlParser;

public class Scaffolder {
    private Scaffolder() {
    }

    public static Scaffolder getInstance() {
        return new Scaffolder();
    }

    public ArtifactDeclaration scaffold(ArtifactDeclaration baseMuleConfig, String wsdlLocation, SoapkitConfig config) {
        return this.scaffold(baseMuleConfig, wsdlLocation, config, null);
    }

    public ArtifactDeclaration scaffold(ArtifactDeclaration baseMuleConfig, String wsdlLocation, SoapkitConfig config, ArtifactDeclaration domainConfig) {
        MuleConfig muleConfig = this.parseMuleConfig(baseMuleConfig);
        WsdlParser apiParser = WsdlParser.create(wsdlLocation, config);
        Optional<Object> apiConfigs = !muleConfig.soapkitConfigs().contains(config) ? Optional.ofNullable(config) : Optional.empty();
        List<String> flows = muleConfig.flowNames();
        List<Flow> newFlows = apiParser.flows().stream().filter(f -> !flows.contains(f.getName())).collect(Collectors.toList());
        List<HttpListenerConfig> newHttpListenerConfigs = Collections.emptyList();
        if (this.routerIsMissingForConfig(muleConfig, config.getName())) {
            MuleDomain domainParser = new MuleDomain(domainConfig);
            List<HttpListenerConfig> domainListenerConfigs = domainParser.httpListenerConfigs();
            List<HttpListenerConfig> projectListenerConfigs = muleConfig.httpListenerConfigs();
            if (domainListenerConfigs.isEmpty() && projectListenerConfigs.isEmpty()) {
                newHttpListenerConfigs = Collections.singletonList(new HttpListenerConfig());
                newFlows.add(0, new SoapkitFlow(apiParser.config(), newHttpListenerConfigs));
            } else {
                newHttpListenerConfigs = Collections.emptyList();
                newFlows.add(0, new SoapkitFlow(apiParser.config(), projectListenerConfigs.isEmpty() ? domainListenerConfigs : projectListenerConfigs));
            }
        }
        return new MuleConfigBuilder(muleConfig.getDeclaration()).withConfig(apiConfigs.orElse(null)).withFlows(newFlows).withHttpListeners(newHttpListenerConfigs).build();
    }

    private boolean routerIsMissingForConfig(MuleConfig muleConfig, String configName) {
        return !muleConfig.getSoapkitFlow(configName).isPresent();
    }

    public ArtifactDeclaration scaffold(String wsdlPath, String wsdlLocationAttribute, String service, String port, ArtifactDeclaration domainConfig) {
        SoapkitFlow soapkitFlow;
        List<HttpListenerConfig> httpListenerConfigs;
        WsdlParser apiParser = WsdlParser.create(wsdlPath, wsdlLocationAttribute, service, port);
        MuleDomain domainParser = new MuleDomain(domainConfig);
        SoapkitConfig config = apiParser.config();
        if (domainParser.httpListenerConfigs().isEmpty()) {
            httpListenerConfigs = Collections.singletonList(new HttpListenerConfig());
            soapkitFlow = new SoapkitFlow(apiParser.config(), httpListenerConfigs);
        } else {
            httpListenerConfigs = Collections.emptyList();
            soapkitFlow = new SoapkitFlow(apiParser.config(), domainParser.httpListenerConfigs());
        }
        ArrayList<Flow> flows = new ArrayList<Flow>(Collections.singletonList(soapkitFlow));
        flows.addAll(apiParser.flows());
        return new MuleConfigBuilder().withConfig(config).withFlows(flows).withHttpListeners(httpListenerConfigs).build();
    }

    public MuleConfig parseMuleConfig(ArtifactDeclaration muleConfig) {
        return new MuleConfig(muleConfig);
    }
}

