/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.scaffolder.model;

import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;

import static org.mule.soapkit.scaffolder.declaration.builders.SoapkitArtifactDeclarationBuilder.PARAMETER_PORT;
import static org.mule.soapkit.scaffolder.declaration.builders.SoapkitArtifactDeclarationBuilder.PARAMETER_SERVICE;
import static org.mule.soapkit.scaffolder.declaration.builders.SoapkitArtifactDeclarationBuilder.PARAMETER_WSDL_LOCATION;
import static org.mule.soapkit.scaffolder.declaration.builders.SoapkitArtifactDeclarationBuilder.buildSoapkitConfig;
import static org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel.CONNECTION;

public class SoapkitConfig implements MuleElement<ConfigurationElementDeclaration> {

  public final static String SOAPKIT_CONFIG_NAME = "soapkit-config";

  private ConfigurationElementDeclaration declaration;

  public SoapkitConfig(String wsdlPath, String service, String port) {
    this(SOAPKIT_CONFIG_NAME, wsdlPath, service, port);
  }

  public SoapkitConfig(String name, String wsdlPath, String service, String port) {
    this(buildSoapkitConfig(name, wsdlPath, service, port));
  }

  public SoapkitConfig(ConfigurationElementDeclaration declaration) {
    this.declaration = declaration;
  }

  @Override
  public String getName() {
    return declaration.getRefName();
  }

  @Override
  public ConfigurationElementDeclaration getDeclaration() {
    return declaration;
  }

  public String getPort() {
    return getConnectionParameterValue(declaration, PARAMETER_PORT);
  }

  public String getService() {
    return getConnectionParameterValue(declaration, PARAMETER_SERVICE);
  }

  public String getWsdlPath() {
    return getConnectionParameterValue(declaration, PARAMETER_WSDL_LOCATION);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o)
      return true;
    if (!(o instanceof SoapkitConfig))
      return false;

    final SoapkitConfig that = (SoapkitConfig) o;

    return getPort() != null && getPort().equals(that.getPort())
        && getService() != null && getService().equals(that.getService())
        && getWsdlPath() != null && getWsdlPath().equals(that.getWsdlPath());
  }

  private static String getConnectionParameterValue(ConfigurationElementDeclaration declaration, String parameter) {
    return declaration.getParameterGroups().stream()
        .filter(pged -> CONNECTION.equals(pged.getName()))
        .flatMap(pged -> pged.getParameters().stream().filter(p -> parameter.equals(p.getName())))
        .map(p -> p.getValue().toString())
        .findFirst()
        .orElse(null);
  }
}
