/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.scaffolder.model;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ConstructElementDeclaration;
import org.mule.soapkit.scaffolder.model.Flow;
import org.mule.soapkit.scaffolder.model.HttpListenerConfig;
import org.mule.soapkit.scaffolder.model.MuleElement;
import org.mule.soapkit.scaffolder.model.SoapkitConfig;

public class MuleConfig
implements MuleElement<ArtifactDeclaration> {
    private final ArtifactDeclaration declaration;

    public MuleConfig(ArtifactDeclaration declaration) {
        this.declaration = declaration;
    }

    public List<SoapkitConfig> soapkitConfigs() {
        return this.listSoapkitConfigs().stream().map(SoapkitConfig::new).collect(Collectors.toList());
    }

    public Optional<SoapkitConfig> apiConfig(String name) {
        for (SoapkitConfig config : this.soapkitConfigs()) {
            if (!config.getName().equals(name)) continue;
            return Optional.of(config);
        }
        return Optional.empty();
    }

    public Optional<Flow> getSoapkitFlow(String configName) {
        return this.listFlows().stream().filter(d -> d.getComponents().stream().anyMatch(c -> "APIKit for SOAP".equals(c.getDeclaringExtension()) && "router".equals(c.getName()) && configName.equals(c.getConfigRef()))).map(Flow::new).findFirst();
    }

    public List<String> flowNames() {
        return this.listFlows().stream().map(ConstructElementDeclaration::getRefName).collect(Collectors.toList());
    }

    public List<HttpListenerConfig> httpListenerConfigs() {
        List<ConfigurationElementDeclaration> httpListenerConfigs = this.listHttpListenerConfigs();
        return httpListenerConfigs.stream().map(HttpListenerConfig::new).collect(Collectors.toList());
    }

    @Override
    public ArtifactDeclaration getDeclaration() {
        return this.declaration;
    }

    @Override
    public String getName() {
        return this.declaration.getName();
    }

    private List<ConfigurationElementDeclaration> listHttpListenerConfigs() {
        return this.declaration.getGlobalElements().stream().filter(ged -> "listenerConfig".equals(ged.getName())).map(ged -> (ConfigurationElementDeclaration)ged).collect(Collectors.toList());
    }

    private List<ConstructElementDeclaration> listFlows() {
        return this.declaration.getGlobalElements().stream().filter(ged -> "flow".equals(ged.getName())).map(ged -> (ConstructElementDeclaration)ged).collect(Collectors.toList());
    }

    private List<ConfigurationElementDeclaration> listSoapkitConfigs() {
        return this.declaration.getGlobalElements().stream().filter(ged -> "config".equals(ged.getName())).map(ged -> (ConfigurationElementDeclaration)ged).collect(Collectors.toList());
    }
}

