/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.scaffolder.model;

import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.List;
import org.mule.runtime.app.declaration.api.ConstructElementDeclaration;
import org.mule.runtime.app.declaration.api.OperationElementDeclaration;
import org.mule.runtime.app.declaration.api.SourceElementDeclaration;
import org.mule.soapkit.scaffolder.declaration.builders.HttpArtifactDeclarationBuilder;
import org.mule.soapkit.scaffolder.declaration.builders.MuleArtifactDeclarationBuilder;
import org.mule.soapkit.scaffolder.declaration.builders.SoapkitArtifactDeclarationBuilder;
import org.mule.soapkit.scaffolder.model.Flow;
import org.mule.soapkit.scaffolder.model.HttpListenerConfig;
import org.mule.soapkit.scaffolder.model.SoapkitConfig;

public class SoapkitFlow
extends Flow {
    private static final String DEFAULT_FLOW_NAME = "api-main";
    private static final String DEFAULT_HTTP_LISTENER_NAME = "api-httpListenerConfig";

    public SoapkitFlow(SoapkitConfig config, List<HttpListenerConfig> httpListenerConfigs) {
        super(SoapkitFlow.buildDeclaration(config, httpListenerConfigs));
    }

    private static ConstructElementDeclaration buildDeclaration(SoapkitConfig config, List<HttpListenerConfig> httpListenerConfigs) {
        String listenerConfigName = SoapkitFlow.getHttpListenerConfigName(httpListenerConfigs);
        SourceElementDeclaration source = HttpArtifactDeclarationBuilder.buildHttpListenerSource(listenerConfigName, SoapkitFlow.buildServicePath(config));
        OperationElementDeclaration router = SoapkitArtifactDeclarationBuilder.buildSoapkitRouterOperation(config.getName());
        return MuleArtifactDeclarationBuilder.buildFlow(DEFAULT_FLOW_NAME, Arrays.asList(source, router));
    }

    private static String getHttpListenerConfigName(List<HttpListenerConfig> httpListenerConfigs) {
        return Ordering.natural().onResultOf(HttpListenerConfig::getPort).nullsLast().immutableSortedCopy(httpListenerConfigs).stream().findFirst().map(HttpListenerConfig::getName).orElse(DEFAULT_HTTP_LISTENER_NAME);
    }

    private static String buildServicePath(SoapkitConfig config) {
        return String.format("/%s/%s", config.getService(), config.getPort());
    }
}

