/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.scaffolder.parsers;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.soapkit.scaffolder.model.Flow;
import org.mule.soapkit.scaffolder.model.SoapkitConfig;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.ServiceModel;
import org.mule.wsdl.parser.model.WsdlModel;
import org.mule.wsdl.parser.model.operation.OperationModel;

public class WsdlParser {
    private final SoapkitConfig config;
    private final WsdlModel wsdlModel;

    private WsdlParser(String wsdlLocation, SoapkitConfig config) {
        this.wsdlModel = WsdlParser.parseWSDL(wsdlLocation);
        this.validateConfig(config);
        this.config = config;
    }

    public static WsdlParser create(String wsdlLocation, SoapkitConfig config) {
        return new WsdlParser(wsdlLocation, config);
    }

    private void validateConfig(SoapkitConfig config) {
        if (config.getWsdlPath() == null) {
            throw new IllegalArgumentException("The given 'wsdLocation' for the SimpleServiceDefinition must not be null (the provided wsdl file is probably unreachable)");
        }
        if (StringUtils.isBlank((CharSequence)config.getService())) {
            throw new IllegalArgumentException("The 'service' attribute cannot be blank");
        }
        if (StringUtils.isBlank((CharSequence)config.getPort())) {
            throw new IllegalArgumentException("The 'port' attribute cannot be blank");
        }
    }

    public static WsdlParser create(String wsdlLocation, String wsdlPath, String serviceName, String portName) {
        return new WsdlParser(wsdlLocation, new SoapkitConfig(wsdlPath, serviceName, portName));
    }

    public List<String> operationNames() {
        ServiceModel service = this.wsdlModel.getService(this.config.getService());
        if (service == null) {
            return Collections.emptyList();
        }
        PortModel port = service.getPort(this.config.getPort());
        if (port == null) {
            return Collections.emptyList();
        }
        return port.getOperations().stream().map(OperationModel::getName).collect(Collectors.toList());
    }

    public List<String> flowNames() {
        return this.operationNames().stream().map(name -> name + ":\\" + this.config.getName()).collect(Collectors.toList());
    }

    public List<Flow> flows() {
        return this.flowNames().stream().map(Flow::new).collect(Collectors.toList());
    }

    public SoapkitConfig config() {
        return this.config;
    }

    private static WsdlModel parseWSDL(String wsdlLocation) {
        try {
            WsdlParser.validateBlankString(wsdlLocation, "wsdl location");
            return org.mule.wsdl.parser.WsdlParser.Companion.parse(wsdlLocation);
        }
        catch (Exception e) {
            String msg = String.format("Something went wrong when parsing the wsdl file %s", StringUtils.isBlank((CharSequence)e.getMessage()) ? " for [" + wsdlLocation + "]" : ", full message " + e.getMessage());
            throw new IllegalArgumentException(msg, e);
        }
    }

    private static void validateBlankString(String paramValue, String paramName) {
        if (StringUtils.isBlank((CharSequence)paramValue)) {
            throw new IllegalArgumentException("The " + paramName + " can not be blank nor null.");
        }
    }
}

