/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tools.muleesb;

import org.mule.test.infrastructure.process.MuleProcessController;

import java.io.File;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

/**
 * Cleans a Mule Standalone server installation.
 * Requires Mule Standalone to be stopped. Deletes <code>.mule</code> directory.
 *
 * @author <a href="mailto:asequeira@gmail.com">Ale Sequeira</a>
 * @see
 * @since 1.0
 */
@Mojo(name = "clean", requiresProject = false, defaultPhase = LifecyclePhase.CLEAN)
public class CleanMojo extends AbstractMuleMojo
{

    /**
     * Absolute path for Mule ESB Standalone server (i.e. $MULE_HOME).
     *
     * @since 1.0
     */
    @Parameter(property = "mule.home", required = true)
    private File muleHome;

    public void doExecute() throws MojoExecutionException, MojoFailureException
    {
        if (!muleHome.exists())
        {
            throw new MojoFailureException("MULE_HOME directory does not exist.");
        }
        MuleProcessController mule = new MuleProcessController(muleHome.getAbsolutePath(), timeout);
        new Cleaner(muleHome, mule, getLog()).execute();
    }
    
}
