/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tools.muleesb;

import org.mule.test.infrastructure.process.MuleProcessController;

import java.io.File;
import java.io.IOException;

import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class Cleaner
{

    private MuleProcessController mule;
    private Log log;
    private File muleHome;

    public Cleaner(File muleHome, MuleProcessController mule, Log log)
    {
        this.muleHome = muleHome;
        this.mule = mule;
        this.log = log;
    }

    public void execute() throws MojoFailureException, MojoExecutionException
    {
        if (mule.isRunning())
        {
            throw new MojoFailureException("Mule ESB is already running.");
        }
        File dotMuleDir = new File(muleHome, ".mule");
        if (!dotMuleDir.exists())
        {
            log.debug("Clean will do nothing, .mule directory does not exist.");
            return;
        }
        try
        {
            log.debug("Cleanning .mule directory: " + dotMuleDir);
            FileUtils.forceDelete(dotMuleDir);
        }
        catch (IOException e)
        {
            throw new MojoFailureException("Could not delete .mule directory: " + dotMuleDir);
        }
        catch (Exception e)
        {
            throw new MojoExecutionException("Unexpected exception when trying to delete .mule directory: " + dotMuleDir);
        }
        
    }

}
