/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tools.muleesb;

import org.mule.test.infrastructure.process.MuleProcessController;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;

import org.apache.maven.plugin.MojoFailureException;

public class ClusterConfigurator
{

    public ClusterConfigurator(){};

    public boolean configureCluster(File[] paths, List<MuleProcessController> mules) throws MojoFailureException
    {
        if (paths.length > 8) throw new MojoFailureException("Cluster size must be between 1 and 8");
        int i = 1;
        for (File f : paths)
        {
            try
            {
                if(!new File(f.getAbsolutePath()+ "/.mule").mkdirs())
                    throw new MojoFailureException("couldn't create .mule dir");
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(
                        new FileOutputStream(f.getAbsolutePath()+"/.mule/mule-cluster.properties"), "utf-8"));
                writer.write("mule.clusterSize=" + paths.length);
                writer.newLine();
                writer.write("mule.clusterSchema=partitioned-sync2backup");
                writer.newLine();
                writer.write("mule.clusterId=" + mules.hashCode());
                writer.newLine();
                writer.write("mule.clusterNodeId=" + i);
                writer.close();
                i++;
            } catch (IOException ex) {
                throw new MojoFailureException("Couldn't create mule-cluster.properties in one of the mules" + ex.getMessage());
            }
        }
        return true;
    }

}
