/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tools.muleesb;

import org.mule.test.infrastructure.process.MuleProcessController;

import java.io.File;
import java.util.LinkedList;
import java.util.List;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

/**
 * Stops a Mule ESB cluster assuming it is already running.
 *
 * @author <a href="mailto:asequeira@gmail.com">Ale Sequeira</a>
 * @see org.mule.tools.muleesb.ClusterDeployMojo
 * @see org.mule.tools.muleesb.ClusterUndeployMojo
 * @see org.mule.test.infrastructure.process.MuleProcessController
 * @since 1.0
 */
@Mojo(name = "clusterStop", requiresProject = false, defaultPhase = LifecyclePhase.POST_INTEGRATION_TEST)
public class ClusterStopMojo extends AbstractMuleMojo
{

    /**
     * Maven coordinates for the Mule ESB distribution to download.
     * You need to specify:
     * <li>groupId</li>
     * <li>artifactId</li>
     * <li>version</li>
     * This parameter and <code>muleVersion</code> are mutual exclusive
     *
     * @since 1.0
     */
    @Parameter(readonly = true, required = true)
    private ArtifactDescription muleDistribution;

    /**
     * Number of cluster nodes. Must be the same number than use in ClusterDeployMojo to create the cluster.
     *
     * @since 1.0
     */
    @Parameter(defaultValue = "2", readonly = true, required = true)
    private Integer clusterSize;

    public void doExecute() throws MojoExecutionException, MojoFailureException
    {
        List<MuleProcessController> controllers = new LinkedList<MuleProcessController>();
        File[] muleHomes = new File[clusterSize];

        for (int i = 0; i < clusterSize; i++)
        {
            muleHomes[i] = new File(mavenProject.getBasedir() + "/target/mule" + i,
                                    "mule-enterprise-standalone-" + muleDistribution.getVersion());

            controllers.add(new MuleProcessController(muleHomes[i].getAbsolutePath(), timeout));

            if (!muleHomes[i].exists()) throw new MojoFailureException(muleHomes[i].getAbsolutePath() + "directory does not exist.");

        }
        new ClusterStopper(controllers, muleHomes, getLog()).execute();
    }

}
