/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tools.muleesb;

import org.mule.test.infrastructure.process.MuleControllerException;
import org.mule.test.infrastructure.process.MuleProcessController;

import java.io.File;
import java.util.List;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class ClusterStopper
{

    private List<MuleProcessController> mules;
    private File[] muleHomes;
    private Log log;

    public ClusterStopper(List<MuleProcessController> mules, File[] muleHomes, Log log)
    {
        this.mules = mules;
        this.muleHomes = muleHomes;
        this.log = log;
    }

    public void execute() throws MojoFailureException, MojoExecutionException
    {
        int i = 0;
        for (MuleProcessController m : mules)
        {
            if (null == muleHomes[i])
            {
                throw new MojoFailureException("MULE_HOME is not set");
            }
            if (!muleHomes[i].exists())
            {
                log.error("Couldn't find MULE_HOME directory at: " + muleHomes[i]);
                throw new MojoFailureException("Configuration variable MULE_HOME was not set.");
            }
            log.info("MULE_HOME is set to: " + muleHomes[i]);
            if (!m.isRunning())
            {
                log.error("Mule ESB is not running.");
                throw new MojoFailureException("Mule ESB is not running.");
            }
            try
            {
                log.debug("Stopping Mule ESB ...");
                m.stop();
                log.info("Mule ESB stopped.");
            }
            catch (MuleControllerException e)
            {
                throw new MojoExecutionException("Error stopping Mule ESB. Please stop it manually.", e);
            }
            catch (Exception e)
            {
                throw new MojoExecutionException("Error stopping Mule ESB. Please stop it manually.", e);
            }
        }

    }

    
}
