/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tools.muleesb;

import org.mule.test.infrastructure.process.MuleProcessController;

import java.io.File;
import java.util.LinkedList;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

/**
 * Undeploys all the applications on a Mule ESB cluster.
 *
 * @author <a href="mailto:asequeira@gmail.com">Ale Sequeira</a>
 * @see org.mule.tools.muleesb.ClusterDeployMojo
 * @since 1.0
 */
@Mojo(name = "clusterUndeploy", requiresProject = true, defaultPhase = LifecyclePhase.POST_INTEGRATION_TEST)
public class ClusterUndeployMojo extends AbstractMojo
{
    @Component
    private MavenProject mavenProject;

    /**
     * Number of cluster nodes. Must be the same number than use in ClusterDeployMojo to create the cluster.
     *
     * @since 1.0
     */
    @Parameter(defaultValue = "2", readonly = true, required = true)
    private Integer clusterSize;

    /**
     * Version of the Mule ESB Enterprise distribution to download. If you need to use Community version use <code>muleDistribution</code> parameter.
     * This parameter and <code>muleDistribution</code> are mutual exclusive.
     *
     * @since 1.0
     */
    @Parameter(readonly = true, property = "mule.version")
    private String muleVersion;

    public void execute() throws MojoExecutionException, MojoFailureException
    {
        List<MuleProcessController> controllers = new LinkedList<MuleProcessController>();
        File[] muleHomes = new File[clusterSize];

        for (int i = 0; i < clusterSize; i++)
        {
            muleHomes[i] = new File(mavenProject.getBasedir() + "/target/mule" + i,
                                    "mule-enterprise-standalone-" + muleVersion);

            controllers.add(new MuleProcessController(muleHomes[i].getAbsolutePath()));

            if (!muleHomes[i].exists()) throw new MojoFailureException(muleHomes[i].getAbsolutePath() + "directory does not exist.");

        }

        new Undeployer(controllers, getLog()).execute();
    }

}
