/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tools.muleesb;

import org.mule.test.infrastructure.process.MuleProcessController;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

/**
 * Installs a Mule ESB license on an installed Mule ESB Standalone Enterprise.
 * Needs the server to be stopped. Fails if it is not an EE server.
 *
 * @author <a href="mailto:asequeira@gmail.com">Ale Sequeira</a>
 * @see org.mule.test.infrastructure.process.MuleProcessController
 * @since 1.0
 */
@Mojo(name = "install-license", requiresProject = false, defaultPhase = LifecyclePhase.VALIDATE)
public class InstallLicenseMojo extends AbstractMuleMojo
{

    /**
     * Absolute path for Mule ESB Standalone server (i.e. $MULE_HOME).
     *
     * @since 1.0
     */
    @Parameter(property = "mule.home", required = true)
    private File muleHome;

    /**
     * Absolute path for Mule ESB License file.
     *
     * @since 1.0
     */
    @Parameter(property = "mule.license", required = true)
    private File licenseFile;
    
    public void doExecute() throws MojoExecutionException, MojoFailureException
    {
        if (!muleHome.exists())
        {
            throw new MojoFailureException("MULE_HOME directory does not exist.");
        }
        validateEnterpriseVersion(muleHome);
        MuleProcessController mule = new MuleProcessController(muleHome.getAbsolutePath(), timeout);
        new LicenseInstaller(mule, getLog(), licenseFile).execute();
    }

    private void validateEnterpriseVersion(File home) throws MojoFailureException
    {
        Scanner scanner = null;
        try
        {
            scanner = new Scanner(new File(home, "LICENSE.txt"));
        }
        catch (FileNotFoundException e)
        {
            throw new MojoFailureException("Cannot install a license in Community Edition.");
        }
        while (scanner.hasNextLine())
        {
            if (scanner.nextLine().contains("CPAL") )
            {
                throw new MojoFailureException("Cannot install a license in Community Edition.");
            }
        }
    }

}
