/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tools.muleesb;

import org.mule.test.infrastructure.process.MuleControllerException;
import org.mule.test.infrastructure.process.MuleProcessController;

import java.io.File;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class LicenseInstaller
{

    private MuleProcessController mule;
    private Log log;
    private File licenseFile;

    public LicenseInstaller(MuleProcessController mule, Log log, File licenseFile)
    {
        this.mule = mule;
        this.log = log;
        this.licenseFile = licenseFile;
    }

    public void execute() throws MojoFailureException, MojoExecutionException
    {
        if(!licenseFile.exists())
        {
            throw new MojoFailureException("License file does not exists: " + licenseFile);
        }
        if(mule.isRunning())
        {
            throw new MojoFailureException("Mule ESB is running. Please stop it before installing license.");
        }
        try
        {
            log.info("Installing license: " + licenseFile);
            mule.installLicense(licenseFile.getAbsolutePath());
        }
        catch (MuleControllerException e)
        {
            throw new MojoFailureException("Error while installing Mule ESB license");
        }
        catch (Exception e)
        {
            throw new MojoExecutionException("Error while installing Mule ESB license",  e);
        }
    }

}
