/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tools.muleesb;

import org.mule.test.infrastructure.process.MuleProcessController;

import java.io.File;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

/**
 * Restarts a Mule ESB Standalone server regardless it was started using <code>start</code> goal or <code>deploy</code> goal, or externally started. You need to provide the path to the Mule server.
 *
 * @author <a href="mailto:asequeira@gmail.com">Ale Sequeira</a>
 * @see org.mule.tools.muleesb.StartMojo
 * @see org.mule.tools.muleesb.DeployMojo
 * @see org.mule.test.infrastructure.process.MuleProcessController
 * @since 1.0
 */
@Mojo(name = "restart", requiresProject = false)
public class RestartMojo extends AbstractMuleMojo
{

    /**
     * Absolute path for Mule ESB Standalone server (i.e. $MULE_HOME).
     *
     * @since 1.0
     */
    @Parameter(property = "mule.home", required = true)
    private File muleHome;

    public void doExecute() throws MojoExecutionException, MojoFailureException
    {
        MuleProcessController mule = new MuleProcessController(muleHome.getAbsolutePath(), timeout);
        new Restarter(mule, muleHome, getLog()).execute();
    }
    
}
