/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tools.muleesb;

import org.mule.test.infrastructure.process.MuleControllerException;
import org.mule.test.infrastructure.process.MuleProcessController;

import java.io.File;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class Restarter
{

    private MuleProcessController mule;
    private File muleHome;
    private Log log;

    public Restarter(MuleProcessController mule, File muleHome, Log log)
    {
        this.mule = mule;
        this.muleHome = muleHome;
        this.log = log;
    }

    public void execute() throws MojoFailureException, MojoExecutionException
    {
        if (null == muleHome)
        {
            throw new MojoFailureException("MULE_HOME is not set");
        }
        if (!muleHome.exists())
        {
            throw new MojoFailureException("Couldn't find MULE_HOME directory at: " + muleHome);
        }
        log.info("MULE_HOME is set to: " + muleHome);
        if (!mule.isRunning())
        {
            throw new MojoFailureException("Mule ESB is not running");
        }
        try
        {
            log.debug("Retarting Mule ESB ...");
            mule.restart();
            log.info("Mule ESB restarted.");
        }
        catch (MuleControllerException e)
        {
            throw new MojoFailureException("Couldn't restart Mule ESB.");
        }
        catch (Exception e)
        {
            throw new MojoExecutionException("Couldn't restart Mule ESB.");
        }
    }


}
