/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tools.muleesb;

import org.mule.test.infrastructure.process.MuleProcessController;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

/**
 * Starts a Mule ESB Standalone server. You need to provide the path to the Mule server.
 *
 * @author <a href="mailto:asequeira@gmail.com">Ale Sequeira</a>
 * @see org.mule.tools.muleesb.StopMojo
 * @see org.mule.test.infrastructure.process.MuleProcessController
 * @since 1.0
 */
@Mojo(name = "start", requiresProject = false, defaultPhase = LifecyclePhase.PRE_INTEGRATION_TEST)
public class StartMojo extends AbstractMuleMojo
{

    private static final long DEFAULT_POLLING_DELAY = 500;

    /**
     * Absolute path for Mule ESB Standalone server (i.e. $MULE_HOME).
     *
     * @since 1.0
     */
    @Parameter(property = "mule.home", required = true)
    private File muleHome;

    /**
     * List of applications to be deployed to Mule ESB. Each application is the full path to a zipped or exploded Mule application.
     *
     * @since 1.0
     */
    @Parameter(property = "mule.applications", required = true)
    private List<File> applications;

    @Parameter(property = "mule.start.timeout", defaultValue = "60000", required = true)
    private Long deploymentTimeout;

    @Parameter(property = "mule.arguments", required = false)
    private String[] arguments;

    @Parameter
    private List<File> libs = new ArrayList<File>();



    public void doExecute() throws MojoFailureException, MojoExecutionException
    {
        if (!muleHome.exists())
        {
            throw new MojoFailureException("MULE_HOME directory does not exist.");
        }
        getLog().info("Using MULE_HOME: " + muleHome);
        MuleProcessController mule = new MuleProcessController(muleHome.getAbsolutePath(), timeout);
        Deployer deployer = new Deployer(mule, getLog(), applications, deploymentTimeout, arguments, DEFAULT_POLLING_DELAY);
        deployer.addLibraries(libs);
        addDependencies(deployer);
        addDomain(deployer);
        deployer.execute();
    }



}
