/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tools.muleesb;

import org.mule.test.infrastructure.process.MuleProcessController;

import java.io.File;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

/**
 * Stops a Mule ESB Standalone server, regardless of whether it was started using start or deploy goals.
 * Assumptions:
 * <li>The plugin started only one Mule ESB server (otherwise the server that is stopped is undefined).</li>
 * <li>Mule ESB Standalone is running.</li>
 *
 * @author <a href="mailto:asequeira@gmail.com">Ale Sequeira</a>
 * @see org.mule.tools.muleesb.StartMojo
 * @see org.mule.tools.muleesb.DeployMojo
 * @since 1.0
 */
@Mojo(name = "stop", requiresProject = false, defaultPhase = LifecyclePhase.POST_INTEGRATION_TEST)
public class StopMojo extends AbstractMuleMojo
{

    @Component
    private MavenProject mavenProject;

    /**
     * Absolute path for Mule ESB Standalone server (i.e. $MULE_HOME).
     *
     * @since 1.0
     */
    @Parameter(property = "mule.home")
    private File muleHome;

    public void doExecute() throws MojoExecutionException, MojoFailureException
    {
        if (muleHome == null)
        {
            muleHome = new File(mavenProject.getProperties().getProperty("mule.home"));
            if (muleHome == null)
            {
                throw new MojoFailureException("MULE_HOME is not defined.");
            }
        }
        MuleProcessController mule = new MuleProcessController(muleHome.getAbsolutePath(), timeout);
        new Stopper(mule, muleHome, getLog()).execute();
    }

}
