/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tools.muleesb;

import org.mule.test.infrastructure.process.MuleProcessController;

import java.io.File;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class Stopper
{

    private MuleProcessController mule;
    private File muleHome;
    private Log log;

    public Stopper(MuleProcessController mule, File muleHome, Log log)
    {
        this.mule = mule;
        this.muleHome = muleHome;
        this.log = log;
    }

    public void execute() throws MojoFailureException, MojoExecutionException
    {
        validate();
        try
        {
            log.debug("Stopping Mule ESB ...");
            mule.stop();
            log.info("Mule ESB stopped.");
        }
        catch (Exception e)
        {
            handleException(e);
        }
    }

    private void handleException(Exception e) throws MojoExecutionException
    {
        int pid;
        try {
            pid = mule.getProcessId();
        } 
        catch (Exception ex)
        {
            throw new MojoExecutionException("Error stopping Mule ESB. Please stop it manually (Unknown PID)", e);
        }
        throw new MojoExecutionException("Error stopping Mule ESB. Please stop it manually (PID: " + pid + ".", e);
    }

    private void validate() throws MojoFailureException
    {
        if (null == muleHome)
        {
            throw new MojoFailureException("MULE_HOME is not set");
        }   
        if (!muleHome.exists())
        {
            log.error("Couldn't find MULE_HOME directory at: " + muleHome);
            throw new MojoFailureException("Configuration variable MULE_HOME was not set.");
        }
        log.info("MULE_HOME is set to: " + muleHome);
        if (!mule.isRunning())
        {
            log.error("Mule ESB is not running.");
            throw new MojoFailureException("Mule ESB is not running.");
        }
    }

    
}
